/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorableProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorableProperties.class);
    private final Map<String, String> map = new LinkedHashMap<String, String>();
    private final DataAccess da;

    public StorableProperties(Directory dir) {
        int segmentSize = 32768;
        this.da = dir.create("properties", segmentSize);
    }

    public synchronized boolean loadExisting() {
        if (!this.da.loadExisting()) {
            return false;
        }
        int len = (int)this.da.getCapacity();
        byte[] bytes = new byte[len];
        this.da.getBytes(0L, bytes, len);
        try {
            StorableProperties.loadProperties(this.map, new StringReader(new String(bytes, Helper.UTF_CS)));
            return true;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized void flush() {
        try {
            StringWriter sw = new StringWriter();
            Helper.saveProperties(this.map, (Writer)sw);
            byte[] bytes = sw.toString().getBytes(Helper.UTF_CS);
            this.da.setBytes(0L, bytes, bytes.length);
            this.da.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized StorableProperties remove(String key) {
        this.map.remove(key);
        return this;
    }

    public synchronized StorableProperties putAll(Map<String, String> externMap) {
        this.map.putAll(externMap);
        return this;
    }

    public synchronized StorableProperties put(String key, String val) {
        this.map.put(key, val);
        return this;
    }

    public synchronized StorableProperties put(String key, Object val) {
        if (!key.equals(Helper.toLowerCase((String)key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        this.map.put(key, val.toString());
        return this;
    }

    public synchronized String get(String key) {
        if (!key.equals(Helper.toLowerCase((String)key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        return this.map.getOrDefault(key, "");
    }

    public synchronized Map<String, String> getAll() {
        return this.map;
    }

    public synchronized void close() {
        this.da.close();
    }

    public synchronized boolean isClosed() {
        return this.da.isClosed();
    }

    public synchronized StorableProperties create(long size) {
        this.da.create(size);
        return this;
    }

    public synchronized long getCapacity() {
        return this.da.getCapacity();
    }

    public synchronized boolean containsVersion() {
        return this.map.containsKey("nodes.version") || this.map.containsKey("edges.version") || this.map.containsKey("geometry.version") || this.map.containsKey("location_index.version") || this.map.containsKey("string_index.version");
    }

    public synchronized String toString() {
        return this.da.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadProperties(Map<String, String> map, Reader tmpReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(tmpReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//") || line.startsWith("#") || Helper.isEmpty((String)line)) continue;
                int index = line.indexOf("=");
                if (index < 0) {
                    LOGGER.warn("Skipping configuration at line:" + line);
                    continue;
                }
                String field = line.substring(0, index);
                String value = line.substring(index + 1);
                map.put(field.trim(), value.trim());
            }
        }
    }
}

