/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.Unzipper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.LongConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Downloader {
    private final String userAgent;
    private String referrer = "http://graphhopper.com";
    private String acceptEncoding = "gzip, deflate";
    private int timeout = 4000;

    public Downloader(String userAgent) {
        this.userAgent = userAgent;
    }

    public static void main(String[] args) throws IOException {
        new Downloader("GraphHopper Downloader").downloadAndUnzip("http://graphhopper.com/public/maps/0.1/europe_germany_berlin.ghz", "somefolder", val -> System.out.println("progress:" + val));
    }

    public Downloader setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Downloader setReferrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    public InputStream fetch(HttpURLConnection connection, boolean readErrorStreamNoException) throws IOException {
        connection.connect();
        InputStream is = readErrorStreamNoException && connection.getResponseCode() >= 400 && connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
        if (is == null) {
            throw new IOException("Stream is null. Message:" + connection.getResponseMessage());
        }
        try {
            String encoding = connection.getContentEncoding();
            if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                is = new GZIPInputStream(is);
            } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
                is = new InflaterInputStream(is, new Inflater(true));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public InputStream fetch(String url) throws IOException {
        return this.fetch(this.createConnection(url), false);
    }

    public HttpURLConnection createConnection(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setUseCaches(true);
        conn.setRequestProperty("Referrer", this.referrer);
        conn.setRequestProperty("User-Agent", this.userAgent);
        conn.setRequestProperty("Accept-Encoding", this.acceptEncoding);
        conn.setReadTimeout(this.timeout);
        conn.setConnectTimeout(this.timeout);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String url, String toFile) throws IOException {
        HttpURLConnection conn = this.createConnection(url);
        InputStream iStream = this.fetch(conn, false);
        int size = 8192;
        BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(toFile), size);
        BufferedInputStream in = new BufferedInputStream(iStream, size);
        try {
            int numRead;
            byte[] buffer = new byte[size];
            while ((numRead = ((InputStream)in).read(buffer)) != -1) {
                writer.write(buffer, 0, numRead);
            }
        }
        finally {
            Helper.close((Closeable)iStream);
            Helper.close((Closeable)writer);
            Helper.close((Closeable)in);
        }
    }

    public void downloadAndUnzip(String url, String toFolder, LongConsumer progressListener) throws IOException {
        HttpURLConnection conn = this.createConnection(url);
        int length = conn.getContentLength();
        InputStream iStream = this.fetch(conn, false);
        new Unzipper().unzip(iStream, new File(toFolder), sumBytes -> progressListener.accept((int)(100L * sumBytes / (long)length)));
    }

    public String downloadAsString(String url, boolean readErrorStreamNoException) throws IOException {
        return Helper.isToString((InputStream)this.fetch(this.createConnection(url), readErrorStreamNoException));
    }
}

