/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class DecimalDetails
extends AbstractPathDetailsBuilder {
    private final DecimalEncodedValue ev;
    private Double decimalValue;
    private final String infinityJsonValue;
    private final double precision;

    public DecimalDetails(String name, DecimalEncodedValue ev) {
        this(name, ev, null, 0.001);
    }

    public DecimalDetails(String name, DecimalEncodedValue ev, String infinityJsonValue, double precision) {
        super(name);
        this.ev = ev;
        this.infinityJsonValue = infinityJsonValue;
        this.precision = precision;
    }

    @Override
    protected Object getCurrentValue() {
        if (Double.isInfinite(this.decimalValue)) {
            return this.infinityJsonValue;
        }
        return this.decimalValue;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        double tmpVal = edge.get(this.ev);
        if (this.decimalValue == null || Math.abs(tmpVal - this.decimalValue) >= this.precision) {
            this.decimalValue = Double.isInfinite(tmpVal) ? tmpVal : (double)Math.round(tmpVal / this.precision) * this.precision;
            return true;
        }
        return false;
    }
}

