/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PointList;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IntersectionDetails
extends AbstractPathDetailsBuilder {
    private int fromEdge = -1;
    private Map<String, Object> intersectionMap = new HashMap<String, Object>();
    private final EdgeExplorer crossingExplorer;
    private final NodeAccess nodeAccess;
    private final Weighting weighting;

    public IntersectionDetails(Graph graph, Weighting weighting) {
        super("intersection");
        this.crossingExplorer = graph.createEdgeExplorer();
        this.nodeAccess = graph.getNodeAccess();
        this.weighting = weighting;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        int toEdge = this.edgeId(edge);
        if (toEdge != this.fromEdge) {
            this.intersectionMap = new HashMap<String, Object>();
            ArrayList<IntersectionValues> intersectingEdges = new ArrayList<IntersectionValues>();
            int baseNode = edge.getBaseNode();
            double startLat = this.nodeAccess.getLat(baseNode);
            double startLon = this.nodeAccess.getLon(baseNode);
            EdgeIterator edgeIter = this.crossingExplorer.setBaseNode(baseNode);
            while (edgeIter.next()) {
                EdgeIteratorState tmpEdge = edgeIter.detach(false);
                IntersectionValues intersectionValues = new IntersectionValues();
                intersectionValues.bearing = this.calculateBearing(startLat, startLon, tmpEdge);
                intersectionValues.in = this.edgeId(tmpEdge) == this.fromEdge;
                intersectionValues.out = this.edgeId(tmpEdge) == this.edgeId(edge);
                intersectionValues.entry = !intersectionValues.in && Double.isFinite(this.weighting.calcEdgeWeight(tmpEdge, false));
                intersectingEdges.add(intersectionValues);
            }
            intersectingEdges.sort(null);
            ArrayList<Integer> bearings = new ArrayList<Integer>(intersectingEdges.size());
            ArrayList<Boolean> entries = new ArrayList<Boolean>(intersectingEdges.size());
            for (int i = 0; i < intersectingEdges.size(); ++i) {
                IntersectionValues intersectionValues = (IntersectionValues)intersectingEdges.get(i);
                bearings.add(intersectionValues.bearing);
                entries.add(intersectionValues.entry);
                if (intersectionValues.in) {
                    this.intersectionMap.put("in", i);
                }
                if (!intersectionValues.out) continue;
                this.intersectionMap.put("out", i);
            }
            this.intersectionMap.put("bearings", bearings);
            this.intersectionMap.put("entries", entries);
            this.fromEdge = toEdge;
            return true;
        }
        return false;
    }

    private int calculateBearing(double startLat, double startLon, EdgeIteratorState tmpEdge) {
        PointList wayGeo = tmpEdge.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ);
        double latitude = wayGeo.getLat(0);
        double longitude = wayGeo.getLon(0);
        return (int)Math.round(AngleCalc.ANGLE_CALC.calcAzimuth(startLat, startLon, latitude, longitude));
    }

    private int edgeId(EdgeIteratorState edge) {
        if (edge instanceof VirtualEdgeIteratorState) {
            return GHUtility.getEdgeFromEdgeKey(((VirtualEdgeIteratorState)edge).getOriginalEdgeKey());
        }
        return edge.getEdge();
    }

    @Override
    public Object getCurrentValue() {
        return this.intersectionMap;
    }

    private class IntersectionValues
    implements Comparable {
        public int bearing;
        public boolean entry;
        public boolean in;
        public boolean out;

        private IntersectionValues() {
        }

        public int compareTo(Object o) {
            if (o instanceof IntersectionValues) {
                return Integer.compare(this.bearing, ((IntersectionValues)o).bearing);
            }
            return 0;
        }
    }
}

