/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.graphhopper.navigation.VoiceInstructionConfig;
import com.graphhopper.util.TranslationMap;
import java.util.Locale;

class ConditionalDistanceVoiceInstructionConfig
extends VoiceInstructionConfig {
    private final int[] distanceAlongGeometry;
    private final int[] distanceVoiceValue;

    public ConditionalDistanceVoiceInstructionConfig(String key, TranslationMap translationMap, Locale locale, int[] distanceAlongGeometry, int[] distanceVoiceValue) {
        super(key, translationMap, locale);
        this.distanceAlongGeometry = distanceAlongGeometry;
        this.distanceVoiceValue = distanceVoiceValue;
        if (distanceAlongGeometry.length != distanceVoiceValue.length) {
            throw new IllegalArgumentException("distanceAlongGeometry and distanceVoiceValue are not same size");
        }
    }

    private int getFittingInstructionIndex(double distanceMeter) {
        for (int i = 0; i < this.distanceAlongGeometry.length; ++i) {
            if (!(distanceMeter >= (double)this.distanceAlongGeometry[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public VoiceInstructionConfig.VoiceInstructionValue getConfigForDistance(double distance, String turnDescription, String thenVoiceInstruction) {
        int instructionIndex = this.getFittingInstructionIndex(distance);
        if (instructionIndex < 0) {
            return null;
        }
        String totalDescription = this.translationMap.getWithFallBack(this.locale).tr("navigate." + this.translationKey, new Object[]{this.distanceVoiceValue[instructionIndex]}) + " " + turnDescription + thenVoiceInstruction;
        int spokenDistance = this.distanceAlongGeometry[instructionIndex];
        return new VoiceInstructionConfig.VoiceInstructionValue(this, spokenDistance, totalDescription);
    }
}

