/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.http.WebHelper;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.util.Constants;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.GHException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="route")
public class RouteResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteResource.class);
    private final GraphHopperAPI graphHopper;
    private final EncodingManager encodingManager;
    private final Boolean hasElevation;

    @Inject
    public RouteResource(GraphHopperAPI graphHopper, EncodingManager encodingManager, @Named(value="hasElevation") Boolean hasElevation) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
        this.hasElevation = hasElevation;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @QueryParam(value="way_point_max_distance") @DefaultValue(value="1") double minPathPrecision, @QueryParam(value="point") List<GHPoint> requestPoints, @QueryParam(value="type") @DefaultValue(value="json") String type, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="vehicle") @DefaultValue(value="car") String vehicleStr, @QueryParam(value="weighting") @DefaultValue(value="fastest") String weighting, @QueryParam(value="algorithm") @DefaultValue(value="") String algoStr, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="point_hint") List<String> pointHints, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="heading") List<Double> favoredHeadings, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="gpx.waypoints") @DefaultValue(value="false") boolean withWayPoints, @QueryParam(value="gpx.trackname") @DefaultValue(value="GraphHopper Track") String trackName, @QueryParam(value="gpx.millis") String timeString) {
        GHRequest request;
        boolean writeGPX = "gpx".equalsIgnoreCase(type);
        instructions = writeGPX || instructions;
        StopWatch sw = new StopWatch().start();
        if (requestPoints.isEmpty()) {
            throw new WebApplicationException(RouteResource.errorResponse(new IllegalArgumentException("You have to pass at least one point"), writeGPX));
        }
        if (!this.encodingManager.supports(vehicleStr)) {
            throw new WebApplicationException(RouteResource.errorResponse(new IllegalArgumentException("Vehicle not supported: " + vehicleStr), writeGPX));
        }
        if (enableElevation && !this.hasElevation.booleanValue()) {
            throw new WebApplicationException(RouteResource.errorResponse(new IllegalArgumentException("Elevation not supported!"), writeGPX));
        }
        if (favoredHeadings.size() > 1 && favoredHeadings.size() != requestPoints.size()) {
            throw new WebApplicationException(RouteResource.errorResponse(new IllegalArgumentException("The number of 'heading' parameters must be <= 1 or equal to the number of points (" + requestPoints.size() + ")"), writeGPX));
        }
        if (pointHints.size() > 0 && pointHints.size() != requestPoints.size()) {
            throw new WebApplicationException(RouteResource.errorResponse(new IllegalArgumentException("If you pass point_hint, you need to pass a hint for every point, empty hints will be ignored"), writeGPX));
        }
        if (favoredHeadings.size() > 0) {
            if (favoredHeadings.size() == 1) {
                ArrayList<Double> paddedHeadings = new ArrayList<Double>(Collections.nCopies(requestPoints.size(), Double.NaN));
                paddedHeadings.set(0, favoredHeadings.get(0));
                request = new GHRequest(requestPoints, paddedHeadings);
            } else {
                request = new GHRequest(requestPoints, favoredHeadings);
            }
        } else {
            request = new GHRequest(requestPoints);
        }
        RouteResource.initHints(request.getHints(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        request.setVehicle(this.encodingManager.getEncoder(vehicleStr).toString()).setWeighting(weighting).setAlgorithm(algoStr).setLocale(localeStr).setPointHints(pointHints).setPathDetails(pathDetails).getHints().put("calc_points", (Object)calcPoints).put("instructions", (Object)instructions).put("way_point_max_distance", (Object)minPathPrecision);
        GHResponse ghResponse = this.graphHopper.route(request);
        float took = sw.stop().getSeconds();
        String infoStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent");
        String logStr = httpReq.getQueryString() + " " + infoStr + " " + requestPoints + ", took:" + took + ", " + algoStr + ", " + weighting + ", " + vehicleStr;
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + ghResponse.getErrors());
            throw new WebApplicationException(RouteResource.errorResponse(ghResponse.getErrors(), writeGPX));
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().getSize() + ", debugInfo: " + ghResponse.getDebugInfo());
        return writeGPX ? RouteResource.gpxSuccessResponseBuilder(ghResponse, timeString, trackName, enableElevation, withRoute, withTrack, withWayPoints, Constants.VERSION).header("X-GH-Took", (Object)("" + Math.round(took * 1000.0f))).build() : Response.ok((Object)WebHelper.jsonObject((GHResponse)ghResponse, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (float)took)).header("X-GH-Took", (Object)("" + Math.round(took * 1000.0f))).build();
    }

    private static Response.ResponseBuilder gpxSuccessResponseBuilder(GHResponse ghRsp, String timeString, String trackName, boolean enableElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version) {
        if (ghRsp.getAll().size() > 1) {
            throw new WebApplicationException("Alternatives are currently not yet supported for GPX");
        }
        long time = timeString != null ? Long.parseLong(timeString) : System.currentTimeMillis();
        return Response.ok((Object)ghRsp.getBest().getInstructions().createGPX(trackName, time, enableElevation, withRoute, withTrack, withWayPoints, version), (String)"application/gpx+xml").header("Content-Disposition", (Object)"attachment;filename=GraphHopper.gpx");
    }

    private static Response xmlErrorResponse(Collection<Throwable> list) {
        if (list.isEmpty()) {
            throw new RuntimeException("errorsToXML should not be called with an empty list");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element gpxElement = doc.createElement("gpx");
            gpxElement.setAttribute("creator", "GraphHopper");
            gpxElement.setAttribute("version", "1.1");
            doc.appendChild(gpxElement);
            Element mdElement = doc.createElement("metadata");
            gpxElement.appendChild(mdElement);
            Element extensionsElement = doc.createElement("extensions");
            mdElement.appendChild(extensionsElement);
            Element messageElement = doc.createElement("message");
            extensionsElement.appendChild(messageElement);
            messageElement.setTextContent(list.iterator().next().getMessage());
            Element hintsElement = doc.createElement("hints");
            extensionsElement.appendChild(hintsElement);
            for (Throwable t : list) {
                Element error = doc.createElement("error");
                hintsElement.appendChild(error);
                error.setAttribute("message", t.getMessage());
                error.setAttribute("details", t.getClass().getName());
            }
            return Response.status((int)400).entity((Object)doc).build();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Response errorResponse(List<Throwable> t, boolean writeGPX) {
        if (writeGPX) {
            return RouteResource.xmlErrorResponse(t);
        }
        return RouteResource.jsonErrorResponse(t);
    }

    private static Response errorResponse(Throwable t, boolean writeGPX) {
        return RouteResource.errorResponse(Collections.singletonList(t), writeGPX);
    }

    private static Response jsonErrorResponse(List<Throwable> errors) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("message", RouteResource.getMessage(errors.get(0)));
        ArrayNode errorHintList = json.putArray("hints");
        for (Throwable t : errors) {
            ObjectNode error = errorHintList.addObject();
            error.put("message", RouteResource.getMessage(t));
            error.put("details", t.getClass().getName());
            if (!(t instanceof GHException)) continue;
            ((GHException)t).getDetails().forEach((arg_0, arg_1) -> ((ObjectNode)error).putPOJO(arg_0, arg_1));
        }
        return Response.status((int)400).entity((Object)json).build();
    }

    public static void initHints(HintsMap m, MultivaluedMap<String, String> parameterMap) {
        for (Map.Entry e : parameterMap.entrySet()) {
            if (((List)e.getValue()).size() != 1) continue;
            m.put((String)e.getKey(), ((List)e.getValue()).get(0));
        }
    }

    private static String getMessage(Throwable t) {
        if (t.getMessage() == null) {
            return t.getClass().getSimpleName();
        }
        return t.getMessage();
    }
}

