/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="i18n")
@Produces(value={"application/json"})
public class I18NResource {
    private final TranslationMap map;

    @Inject
    public I18NResource(TranslationMap map) {
        this.map = map;
    }

    @GET
    public Response getFromHeader(@HeaderParam(value="Accept-Language") String acceptLang) {
        return this.get(acceptLang.split(",")[0]);
    }

    @GET
    @Path(value="/{locale}")
    public Response get(@PathParam(value="locale") String locale) {
        Translation tr = this.map.get(locale);
        Response json = new Response();
        if (tr != null && !Locale.US.equals(tr.getLocale())) {
            json.defaultTr = tr.asMap();
        }
        json.locale = locale;
        json.en = this.map.get("en").asMap();
        return json;
    }

    public static class Response {
        public String locale;
        public Map<String, String> en;
        @JsonProperty(value="default")
        public Map<String, String> defaultTr;
    }
}

