/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.Constants;
import com.graphhopper.util.shapes.BBox;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="info")
@Produces(value={"application/json"})
public class InfoResource {
    private final GraphHopperStorage storage;
    private boolean hasElevation;

    @Inject
    public InfoResource(GraphHopperStorage storage, @Named(value="hasElevation") Boolean hasElevation) {
        this.storage = storage;
        this.hasElevation = hasElevation;
    }

    @GET
    public Info getInfo() {
        Info info = new Info();
        info.bbox = this.storage.getBounds();
        for (String v : info.supported_vehicles = this.storage.getEncodingManager().toString().split(",")) {
            Info.PerVehicle perVehicleJson = new Info.PerVehicle();
            perVehicleJson.elevation = this.hasElevation;
            info.features.put(v, perVehicleJson);
        }
        info.import_date = this.storage.getProperties().get("datareader.import.date");
        info.data_date = this.storage.getProperties().get("datareader.data.date");
        info.prepare_ch_date = this.storage.getProperties().get("prepare.ch.date");
        info.prepare_date = this.storage.getProperties().get("prepare.ch.date");
        return info;
    }

    public static class Info {
        public BBox bbox;
        public String[] supported_vehicles;
        public final Map<String, PerVehicle> features = new HashMap<String, PerVehicle>();
        public String version = Constants.VERSION;
        public String build_date = Constants.BUILD_DATE;
        public String import_date;
        public String data_date;
        public String prepare_ch_date;
        public String prepare_date;

        public static class PerVehicle {
            public boolean elevation;
        }
    }
}

