/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupHelper;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.swl.DefaultSpeedCalculator;
import com.graphhopper.swl.FastestCarTDWeighting;
import com.graphhopper.swl.FileSpeedCalculator;
import com.graphhopper.swl.PathDetailsBuilderFactoryWithEdgeKey;
import com.graphhopper.swl.SpeedCalculator;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.shapes.BBox;
import io.dropwizard.lifecycle.Managed;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphHopper graphHopper;

    public GraphHopperManaged(CmdArgs configuration, ObjectMapper objectMapper) {
        JsonFeatureCollection landmarkSplittingFeatureCollection;
        String linkSpeedFile = configuration.get("r5.link_speed_file", null);
        final SpeedCalculator speedCalculator = linkSpeedFile != null ? new FileSpeedCalculator(linkSpeedFile) : new DefaultSpeedCalculator();
        String splitAreaLocation = configuration.get("prepare.lm.split_area_location", "");
        try (InputStreamReader reader = splitAreaLocation.isEmpty() ? new InputStreamReader(LandmarkStorage.class.getResource("map.geo.json").openStream(), Helper.UTF_CS) : new InputStreamReader((InputStream)new FileInputStream(splitAreaLocation), Helper.UTF_CS);){
            landmarkSplittingFeatureCollection = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
        }
        catch (IOException e1) {
            this.logger.error("Problem while reading border map GeoJSON. Skipping this.", (Throwable)e1);
            landmarkSplittingFeatureCollection = null;
        }
        this.graphHopper = new GraphHopperOSM(landmarkSplittingFeatureCollection){

            public Weighting createWeighting(HintsMap hintsMap, FlagEncoder encoder, Graph graph) {
                if (hintsMap.getWeighting().equals("td")) {
                    return new FastestCarTDWeighting(encoder, speedCalculator, (PMap)hintsMap);
                }
                return super.createWeighting(hintsMap, encoder, graph);
            }
        }.forServer();
        String spatialRuleLocation = configuration.get("spatial_rules.location", "");
        if (!spatialRuleLocation.isEmpty()) {
            BBox maxBounds = BBox.parseBBoxString((String)configuration.get("spatial_rules.max_bbox", "-180, 180, -90, 90"));
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(spatialRuleLocation), Helper.UTF_CS);){
                JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                SpatialRuleLookupHelper.buildAndInjectSpatialRuleIntoGH((GraphHopper)this.graphHopper, (BBox)maxBounds, (JsonFeatureCollection)jsonFeatureCollection);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.graphHopper.init(configuration);
        this.graphHopper.setPathDetailsBuilderFactory((PathDetailsBuilderFactory)new PathDetailsBuilderFactoryWithEdgeKey());
    }

    public void start() {
        this.graphHopper.importOrLoad();
        this.logger.info("loaded graph at:" + this.graphHopper.getGraphHopperLocation() + ", data_reader_file:" + this.graphHopper.getDataReaderFile() + ", flag_encoders:" + this.graphHopper.getEncodingManager() + ", " + this.graphHopper.getGraphHopperStorage().toDetailsString());
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

