/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.swl;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.TDWeighting;
import com.graphhopper.swl.SpeedCalculator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class FastestCarTDWeighting
implements TDWeighting {
    protected static final double SPEED_CONV = 3.6;
    private final double maxSpeed;
    private final FlagEncoder encoder;
    private final SpeedCalculator speedCalculator;
    private final long headingPenaltyMillis;
    private final double headingPenalty;
    private long initialTime;

    public FastestCarTDWeighting(FlagEncoder encoder, SpeedCalculator speedCalculator, PMap map) {
        this.encoder = encoder;
        this.maxSpeed = encoder.getMaxSpeed() / 3.6;
        this.speedCalculator = speedCalculator;
        this.headingPenalty = map.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(this.headingPenalty * 1000.0);
    }

    public double getMinWeight(double distance) {
        return distance / this.maxSpeed;
    }

    public double calcWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        throw new RuntimeException();
    }

    public long calcMillis(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        throw new RuntimeException();
    }

    public double calcTDWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId, long linkEnterTime) {
        double speed = this.speedCalculator.getSpeed(edge, reverse, (int)(linkEnterTime / 1000L), this.encoder);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double time = edge.getDistance() / speed * 3.6;
        boolean unfavoredEdge = edge.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenalty;
        }
        return time;
    }

    public long calcTDMillis(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId, long linkEnterTime) {
        double speed = this.speedCalculator.getSpeed(edge, reverse, (int)(linkEnterTime / 1000L), this.encoder);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid speed stored in edge! " + speed);
        }
        if (speed == 0.0) {
            throw new IllegalStateException("Speed cannot be 0 for unblocked edge, use access properties to mark edge blocked! Should only occur for shortest path calculation. See #242.");
        }
        long time = (long)(edge.getDistance() * 3600.0 / speed);
        boolean unfavoredEdge = edge.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenaltyMillis;
        }
        return time;
    }

    public FlagEncoder getFlagEncoder() {
        return this.encoder;
    }

    public String getName() {
        return "td";
    }

    public boolean matches(HintsMap reqMap) {
        return this.getName().equals(reqMap.getWeighting()) && this.encoder.toString().equals(reqMap.getVehicle());
    }

    public String toString() {
        return this.getName();
    }
}

