/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.swl;

import com.csvreader.CsvReader;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.swl.DefaultSpeedCalculator;
import com.graphhopper.swl.EdgeKeys;
import com.graphhopper.swl.SpeedCalculator;
import com.graphhopper.util.EdgeIteratorState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpeedCalculator
implements SpeedCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(FileSpeedCalculator.class);
    private final SpeedCalculator delegateTravelTimeCalculator;
    private Map<Integer, short[]> linkTravelTimes;

    public FileSpeedCalculator(String path) {
        this.linkTravelTimes = FileSpeedCalculator.readTravelTimes(new File(path));
        this.delegateTravelTimeCalculator = new DefaultSpeedCalculator();
    }

    @Override
    public double getSpeed(EdgeIteratorState edgeState, boolean reverse, int currentTimeSeconds, FlagEncoder encoder) {
        short[] speeds;
        if (this.linkTravelTimes != null && (speeds = this.linkTravelTimes.get(EdgeKeys.getEdgeKey(edgeState))) != null) {
            int timebinIndex = currentTimeSeconds / 900 % 96;
            double speedms = (double)speeds[timebinIndex] / 3.6;
            return speedms;
        }
        return this.delegateTravelTimeCalculator.getSpeed(edgeState, reverse, currentTimeSeconds, encoder);
    }

    private static Map<Integer, short[]> readTravelTimes(File file) {
        HashMap<Integer, short[]> res = new HashMap<Integer, short[]>();
        LOG.warn("Processing {}", (Object)file.toString());
        try (FileInputStream is = new FileInputStream(file);){
            CsvReader reader = new CsvReader((InputStream)is, ',', Charset.forName("UTF-8"));
            reader.readHeaders();
            while (reader.readRecord()) {
                int edgeId = Integer.parseInt(reader.get("edgeId"));
                int[] speeds = IntStream.range(0, 24).mapToObj(Integer::toString).flatMap(hour -> {
                    try {
                        return Stream.of(Short.parseShort(reader.get(hour + "h_1")), Short.parseShort(reader.get(hour + "h_2")), Short.parseShort(reader.get(hour + "h_3")), Short.parseShort(reader.get(hour + "h_4")));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).mapToInt(v -> v.shortValue()).toArray();
                short[] shortSpeeds = new short[speeds.length];
                for (int i = 0; i < speeds.length; ++i) {
                    shortSpeeds[i] = (short)speeds[i];
                }
                res.put(edgeId, shortSpeeds);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception while loading travel times.");
        }
        LOG.warn("Done.");
        return res;
    }
}

