/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.swl;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.swl.EdgeKeyDetails;
import com.graphhopper.util.details.AverageSpeedDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.StreetNameDetails;
import com.graphhopper.util.details.TimeDetails;
import java.util.ArrayList;
import java.util.List;

public class PathDetailsBuilderFactoryWithEdgeKey
extends PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, FlagEncoder encoder, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("average_speed")) {
            builders.add((PathDetailsBuilder)new AverageSpeedDetails(encoder));
        }
        if (requestedPathDetails.contains("street_name")) {
            builders.add((PathDetailsBuilder)new StreetNameDetails());
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add((PathDetailsBuilder)new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add((PathDetailsBuilder)new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("edge_key")) {
            builders.add((PathDetailsBuilder)new EdgeKeyDetails());
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

