/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.http.GHPointConverterProvider;
import com.graphhopper.http.GraphHopperBundleConfiguration;
import com.graphhopper.http.GraphHopperManaged;
import com.graphhopper.http.IllegalArgumentExceptionMapper;
import com.graphhopper.http.MultiExceptionGPXMessageBodyWriter;
import com.graphhopper.http.MultiExceptionMapper;
import com.graphhopper.http.TypeGPXFilter;
import com.graphhopper.http.health.GraphHopperHealthCheck;
import com.graphhopper.http.health.GraphHopperStorageHealthCheck;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.reader.gtfs.GraphHopperGtfs;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.PtEncodedValues;
import com.graphhopper.resources.ChangeGraphResource;
import com.graphhopper.resources.I18NResource;
import com.graphhopper.resources.InfoResource;
import com.graphhopper.resources.IsochroneResource;
import com.graphhopper.resources.MVTResource;
import com.graphhopper.resources.NearestResource;
import com.graphhopper.resources.PtIsochroneResource;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.resources.SPTResource;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.PMap;
import com.graphhopper.util.TranslationMap;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class GraphHopperBundle
implements ConfiguredBundle<GraphHopperBundleConfiguration> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.setObjectMapper(io.dropwizard.jackson.Jackson.newMinimalObjectMapper());
        bootstrap.getObjectMapper().registerModule((Module)new Jdk8Module());
        Jackson.initObjectMapper((ObjectMapper)bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().setDateFormat((DateFormat)new StdDateFormat());
        bootstrap.getObjectMapper().registerModule((Module)new SimpleModule().setSerializerModifier(new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                return beanProperties.stream().map(bpw -> new BeanPropertyWriter((BeanPropertyWriter)bpw){

                    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
                        try {
                            super.serializeAsField(bean, gen, prov);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).collect(Collectors.toList());
            }
        }));
    }

    public void run(GraphHopperBundleConfiguration configuration, Environment environment) {
        configuration.getGraphHopperConfiguration().merge((PMap)CmdArgs.readFromSystemProperties());
        environment.jersey().register((Object)new TypeGPXFilter());
        environment.jersey().register((Object)new MultiExceptionMapper());
        environment.jersey().register((Object)new MultiExceptionGPXMessageBodyWriter());
        environment.jersey().register((Object)new IllegalArgumentExceptionMapper());
        environment.jersey().register((Object)new GHPointConverterProvider());
        if (configuration.getGraphHopperConfiguration().has("gtfs.file")) {
            this.runPtGraphHopper(configuration.getGraphHopperConfiguration(), environment);
        } else {
            this.runRegularGraphHopper(configuration.getGraphHopperConfiguration(), environment);
        }
    }

    private void runPtGraphHopper(final CmdArgs configuration, Environment environment) {
        GHDirectory ghDirectory = new GHDirectory(configuration.get("graph.location", "target/tmp"), DAType.RAM_STORE);
        final GtfsStorage gtfsStorage = GtfsStorage.createOrLoad((Directory)ghDirectory);
        final EncodingManager encodingManager = PtEncodedValues.createAndAddEncodedValues((EncodingManager.Builder)EncodingManager.start()).add((FlagEncoder)new CarFlagEncoder()).add((FlagEncoder)new FootFlagEncoder()).build();
        final GraphHopperStorage graphHopperStorage = GraphHopperGtfs.createOrLoad((GHDirectory)ghDirectory, (EncodingManager)encodingManager, (GtfsStorage)gtfsStorage, configuration.has("gtfs.file") ? Arrays.asList(configuration.get("gtfs.file", "").split(",")) : Collections.emptyList(), configuration.has("datareader.file") ? Arrays.asList(configuration.get("datareader.file", "").split(",")) : Collections.emptyList());
        final TranslationMap translationMap = new TranslationMap().doImport();
        final LocationIndex locationIndex = GraphHopperGtfs.createOrLoadIndex((GHDirectory)ghDirectory, (GraphHopperStorage)graphHopperStorage);
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(configuration).to(CmdArgs.class);
                this.bind(false).to(Boolean.class).named("hasElevation");
                this.bind(locationIndex).to(LocationIndex.class);
                this.bind(translationMap).to(TranslationMap.class);
                this.bind(encodingManager).to(EncodingManager.class);
                this.bind(graphHopperStorage).to(GraphHopperStorage.class);
                this.bind(gtfsStorage).to(GtfsStorage.class);
            }
        });
        environment.jersey().register(NearestResource.class);
        environment.jersey().register(GraphHopperGtfs.class);
        environment.jersey().register((Object)new PtIsochroneResource(gtfsStorage, encodingManager, graphHopperStorage, locationIndex));
        environment.jersey().register(I18NResource.class);
        environment.jersey().register(InfoResource.class);
        environment.jersey().register(context -> {
            if (context.getEntity() instanceof InfoResource.Info) {
                InfoResource.Info info = (InfoResource.Info)context.getEntity();
                info.supported_vehicles = new String[]{"pt"};
                info.features.clear();
                info.features.put("pt", new InfoResource.Info.PerVehicle());
                context.setEntity((Object)info);
            }
            context.proceed();
        });
        environment.lifecycle().manage(new Managed(){

            public void start() {
            }

            public void stop() {
                locationIndex.close();
                gtfsStorage.close();
                graphHopperStorage.close();
            }
        });
        environment.healthChecks().register("graphhopper-storage", (HealthCheck)new GraphHopperStorageHealthCheck(graphHopperStorage));
    }

    private void runRegularGraphHopper(final CmdArgs configuration, Environment environment) {
        final GraphHopperManaged graphHopperManaged = new GraphHopperManaged(configuration, environment.getObjectMapper());
        environment.lifecycle().manage((Managed)graphHopperManaged);
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(configuration).to(CmdArgs.class);
                this.bind(graphHopperManaged).to(GraphHopperManaged.class);
                this.bind(graphHopperManaged.getGraphHopper()).to(GraphHopper.class);
                this.bind(graphHopperManaged.getGraphHopper()).to(GraphHopperAPI.class);
                this.bindFactory(HasElevation.class).to(Boolean.class).named("hasElevation");
                this.bindFactory(LocationIndexFactory.class).to(LocationIndex.class);
                this.bindFactory(TranslationMapFactory.class).to(TranslationMap.class);
                this.bindFactory(EncodingManagerFactory.class).to(EncodingManager.class);
                this.bindFactory(GraphHopperStorageFactory.class).to(GraphHopperStorage.class);
            }
        });
        if (configuration.getBool("web.change_graph.enabled", false)) {
            environment.jersey().register(ChangeGraphResource.class);
        }
        environment.jersey().register(MVTResource.class);
        environment.jersey().register(NearestResource.class);
        environment.jersey().register(RouteResource.class);
        environment.jersey().register(IsochroneResource.class);
        environment.jersey().register(SPTResource.class);
        environment.jersey().register(I18NResource.class);
        environment.jersey().register(InfoResource.class);
        environment.healthChecks().register("graphhopper", (HealthCheck)new GraphHopperHealthCheck(graphHopperManaged.getGraphHopper()));
    }

    static class HasElevation
    implements Factory<Boolean> {
        @Inject
        GraphHopper graphHopper;

        HasElevation() {
        }

        public Boolean provide() {
            return this.graphHopper.hasElevation();
        }

        public void dispose(Boolean instance) {
        }
    }

    static class LocationIndexFactory
    implements Factory<LocationIndex> {
        @Inject
        GraphHopper graphHopper;

        LocationIndexFactory() {
        }

        public LocationIndex provide() {
            return this.graphHopper.getLocationIndex();
        }

        public void dispose(LocationIndex instance) {
        }
    }

    static class EncodingManagerFactory
    implements Factory<EncodingManager> {
        @Inject
        GraphHopper graphHopper;

        EncodingManagerFactory() {
        }

        public EncodingManager provide() {
            return this.graphHopper.getEncodingManager();
        }

        public void dispose(EncodingManager instance) {
        }
    }

    static class GraphHopperStorageFactory
    implements Factory<GraphHopperStorage> {
        @Inject
        GraphHopper graphHopper;

        GraphHopperStorageFactory() {
        }

        public GraphHopperStorage provide() {
            return this.graphHopper.getGraphHopperStorage();
        }

        public void dispose(GraphHopperStorage instance) {
        }
    }

    static class TranslationMapFactory
    implements Factory<TranslationMap> {
        @Inject
        GraphHopper graphHopper;

        TranslationMapFactory() {
        }

        public TranslationMap provide() {
            return this.graphHopper.getTranslationMap();
        }

        public void dispose(TranslationMap instance) {
        }
    }
}

