/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.http.WebHelper;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.reader.gtfs.GraphExplorer;
import com.graphhopper.reader.gtfs.GtfsStorage;
import com.graphhopper.reader.gtfs.Label;
import com.graphhopper.reader.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.reader.gtfs.PtFlagEncoder;
import com.graphhopper.reader.gtfs.RealtimeFeed;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Path(value="isochrone")
public class PtIsochroneResource {
    private static final double JTS_TOLERANCE = 1.0E-5;
    private GtfsStorage gtfsStorage;
    private EncodingManager encodingManager;
    private GraphHopperStorage graphHopperStorage;
    private LocationIndex locationIndex;
    private final Function<Label, Double> z = label -> label.currentTime;

    public PtIsochroneResource(GtfsStorage gtfsStorage, EncodingManager encodingManager, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex) {
        this.gtfsStorage = gtfsStorage;
        this.encodingManager = encodingManager;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@QueryParam(value="point") GHPoint source, @QueryParam(value="time_limit") @DefaultValue(value="600") long seconds, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="pt.earliest_departure_time") String departureTimeString, @QueryParam(value="pt.blocked_route_types") @DefaultValue(value="0") int blockedRouteTypes, @QueryParam(value="result") @DefaultValue(value="multipolygon") String format) {
        Instant initialTime;
        try {
            initialTime = Instant.parse(departureTimeString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal value for required parameter %s: [%s]", "pt.earliest_departure_time", departureTimeString));
        }
        double targetZ = initialTime.toEpochMilli() + seconds * 1000L;
        GeometryFactory geometryFactory = new GeometryFactory();
        DefaultEdgeFilter filter = DefaultEdgeFilter.allEdges((FlagEncoder)this.graphHopperStorage.getEncodingManager().getEncoder("foot"));
        QueryResult queryResult = this.locationIndex.findClosest(source.lat, source.lon, (EdgeFilter)filter);
        QueryGraph queryGraph = QueryGraph.lookup((Graph)this.graphHopperStorage, Collections.singletonList(queryResult));
        if (!queryResult.isValid()) {
            throw new IllegalArgumentException("Cannot find point: " + source);
        }
        PtFlagEncoder ptFlagEncoder = (PtFlagEncoder)this.encodingManager.getEncoder("pt");
        GraphExplorer graphExplorer = new GraphExplorer((Graph)queryGraph, (Weighting)new FastestWeighting(this.encodingManager.getEncoder("foot")), ptFlagEncoder, this.gtfsStorage, RealtimeFeed.empty((GtfsStorage)this.gtfsStorage), reverseFlow, false, 5.0);
        MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptFlagEncoder, reverseFlow, Double.MAX_VALUE, false, false, false, 1000000, Collections.emptyList());
        final HashMap z1 = new HashMap();
        final NodeAccess nodeAccess = queryGraph.getNodeAccess();
        MultiCriteriaLabelSetting.SPTVisitor sptVisitor = nodeLabel -> {
            Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLongitude(nodeLabel.adjNode), nodeAccess.getLatitude(nodeLabel.adjNode));
            z1.merge(nodeCoordinate, this.z.apply(nodeLabel), Math::min);
        };
        if (format.equals("multipoint")) {
            router.calcLabels(queryResult.getClosestNode(), -1, initialTime, blockedRouteTypes, sptVisitor, label -> (double)label.currentTime <= targetZ);
            MultiPoint exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
            return this.wrap((Geometry)exploredPoints);
        }
        router.calcLabelsAndNeighbors(queryResult.getClosestNode(), -1, initialTime, blockedRouteTypes, sptVisitor, label -> (double)label.currentTime <= targetZ);
        MultiPoint exploredPointsAndNeighbors = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        this.locationIndex.query(BBox.fromEnvelope((Envelope)exploredPointsAndNeighbors.getEnvelopeInternal()), new LocationIndex.Visitor(){

            public void onNode(int nodeId) {
                Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLongitude(nodeId), nodeAccess.getLatitude(nodeId));
                z1.merge(nodeCoordinate, Double.MAX_VALUE, Math::min);
            }
        });
        exploredPointsAndNeighbors = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        CoordinateList siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates((Geometry)exploredPointsAndNeighbors);
        ArrayList<ConstraintVertex> constraintVertices = new ArrayList<ConstraintVertex>();
        for (Object siteCoord : siteCoords) {
            Coordinate coord = (Coordinate)siteCoord;
            constraintVertices.add(new ConstraintVertex(coord));
        }
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(constraintVertices, 1.0E-5);
        cdt.setConstraints(new ArrayList(), new ArrayList());
        cdt.formInitialDelaunay();
        QuadEdgeSubdivision tin = cdt.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (tin.isFrameVertex(vertex)) {
                vertex.setZ(Double.MAX_VALUE);
                continue;
            }
            Double aDouble = (Double)z1.get(vertex.getCoordinate());
            if (aDouble != null) {
                vertex.setZ(aDouble.doubleValue());
                continue;
            }
            vertex.setZ(Double.MAX_VALUE);
        }
        ContourBuilder contourBuilder = new ContourBuilder(tin);
        MultiPolygon isoline = contourBuilder.computeIsoline(targetZ);
        if (format.equals("triangulation")) {
            HashMap<String, Double> properties;
            JsonFeature feature;
            Response response = new Response();
            for (Vertex vertex : tin.getVertices(true)) {
                feature = new JsonFeature();
                feature.setGeometry((Geometry)geometryFactory.createPoint(vertex.getCoordinate()));
                properties = new HashMap<String, Double>();
                properties.put("z", vertex.getZ());
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            for (QuadEdge edge : tin.getPrimaryEdges(false)) {
                feature = new JsonFeature();
                feature.setGeometry((Geometry)edge.toLineSegment().toGeometry(geometryFactory));
                properties = new HashMap();
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            JsonFeature feature2 = new JsonFeature();
            feature2.setGeometry((Geometry)isoline);
            HashMap<String, Double> properties2 = new HashMap<String, Double>();
            properties2.put("z", targetZ);
            feature2.setProperties(properties2);
            response.polygons.add(feature2);
            response.info.copyrights.addAll(WebHelper.COPYRIGHTS);
            return response;
        }
        return this.wrap((Geometry)isoline);
    }

    private Response wrap(Geometry isoline) {
        JsonFeature feature = new JsonFeature();
        feature.setGeometry(isoline);
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("bucket", 0);
        feature.setProperties(properties);
        Response response = new Response();
        response.polygons.add(feature);
        response.info.copyrights.addAll(WebHelper.COPYRIGHTS);
        return response;
    }

    public static class Response {
        public List<JsonFeature> polygons = new ArrayList<JsonFeature>();
        public Info info = new Info();

        public static class Info {
            public List<String> copyrights = new ArrayList<String>();
        }
    }
}

