/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.MultiException;
import com.graphhopper.http.WebHelper;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.util.Constants;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.gpx.GpxFromInstructions;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="route")
public class RouteResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteResource.class);
    private final GraphHopperAPI graphHopper;
    private final Boolean hasElevation;

    @Inject
    public RouteResource(GraphHopperAPI graphHopper, @Named(value="hasElevation") Boolean hasElevation) {
        this.graphHopper = graphHopper;
        this.hasElevation = hasElevation;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @Context ContainerRequestContext rc, @QueryParam(value="way_point_max_distance") @DefaultValue(value="1") double minPathPrecision, @QueryParam(value="point") List<GHPoint> requestPoints, @QueryParam(value="type") @DefaultValue(value="json") String type, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="vehicle") @DefaultValue(value="car") String vehicleStr, @QueryParam(value="weighting") @DefaultValue(value="fastest") String weighting, @QueryParam(value="algorithm") @DefaultValue(value="") String algoStr, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="point_hint") List<String> pointHints, @QueryParam(value="curbside") List<String> curbSides, @QueryParam(value="snap_prevention") List<String> snapPreventions, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="heading") List<Double> favoredHeadings, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="gpx.waypoints") @DefaultValue(value="false") boolean withWayPoints, @QueryParam(value="gpx.trackname") @DefaultValue(value="GraphHopper Track") String trackName, @QueryParam(value="gpx.millis") String timeString) {
        GHRequest request;
        boolean writeGPX = "gpx".equalsIgnoreCase(type);
        instructions = writeGPX || instructions;
        StopWatch sw = new StopWatch().start();
        if (requestPoints.isEmpty()) {
            throw new IllegalArgumentException("You have to pass at least one point");
        }
        if (enableElevation && !this.hasElevation.booleanValue()) {
            throw new IllegalArgumentException("Elevation not supported!");
        }
        if (favoredHeadings.size() > 1 && favoredHeadings.size() != requestPoints.size()) {
            throw new IllegalArgumentException("The number of 'heading' parameters must be <= 1 or equal to the number of points (" + requestPoints.size() + ")");
        }
        if (pointHints.size() > 0 && pointHints.size() != requestPoints.size()) {
            throw new IllegalArgumentException("If you pass point_hint, you need to pass exactly one hint for every point, empty hints will be ignored");
        }
        if (curbSides.size() > 0 && curbSides.size() != requestPoints.size()) {
            throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
        }
        if (favoredHeadings.size() > 0) {
            if (favoredHeadings.size() == 1) {
                ArrayList<Double> paddedHeadings = new ArrayList<Double>(Collections.nCopies(requestPoints.size(), Double.NaN));
                paddedHeadings.set(0, favoredHeadings.get(0));
                request = new GHRequest(requestPoints, paddedHeadings);
            } else {
                request = new GHRequest(requestPoints, favoredHeadings);
            }
        } else {
            request = new GHRequest(requestPoints);
        }
        RouteResource.initHints(request.getHints(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.translateTurnCostsParamToEdgeBased(request, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.enableEdgeBasedIfThereAreCurbSides(curbSides, request);
        request.setVehicle(vehicleStr).setWeighting(weighting).setAlgorithm(algoStr).setLocale(localeStr).setPointHints(pointHints).setCurbSides(curbSides).setSnapPreventions(snapPreventions).setPathDetails(pathDetails).getHints().put("calc_points", (Object)calcPoints).put("instructions", (Object)instructions).put("way_point_max_distance", (Object)minPathPrecision);
        GHResponse ghResponse = this.graphHopper.route(request);
        float took = sw.stop().getSeconds();
        String infoStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent");
        String logStr = httpReq.getQueryString() + " " + infoStr + " " + requestPoints + ", took:" + took + ", " + algoStr + ", " + weighting + ", " + vehicleStr;
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + ghResponse.getErrors());
            throw new MultiException(ghResponse.getErrors());
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().getSize() + ", debugInfo: " + ghResponse.getDebugInfo());
        return writeGPX ? RouteResource.gpxSuccessResponseBuilder(ghResponse, timeString, trackName, enableElevation, withRoute, withTrack, withWayPoints, Constants.VERSION).header("X-GH-Took", (Object)("" + Math.round(took * 1000.0f))).build() : Response.ok((Object)WebHelper.jsonObject((GHResponse)ghResponse, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (float)took)).header("X-GH-Took", (Object)("" + Math.round(took * 1000.0f))).build();
    }

    private void enableEdgeBasedIfThereAreCurbSides(List<String> curbSides, GHRequest request) {
        if (!curbSides.isEmpty()) {
            if (!request.getHints().getBool("edge_based", true)) {
                throw new IllegalArgumentException("Disabling 'edge_based' when using 'curbside' is not allowed");
            }
            request.getHints().put("edge_based", (Object)true);
        }
    }

    private void translateTurnCostsParamToEdgeBased(GHRequest request, MultivaluedMap<String, String> queryParams) {
        if (queryParams.containsKey((Object)"turn_costs")) {
            List turnCosts = (List)queryParams.get((Object)"turn_costs");
            if (turnCosts.size() != 1) {
                throw new IllegalArgumentException("You may only specify the turn_costs parameter once");
            }
            request.getHints().put("edge_based", turnCosts.get(0));
        }
    }

    private static Response.ResponseBuilder gpxSuccessResponseBuilder(GHResponse ghRsp, String timeString, String trackName, boolean enableElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version) {
        if (ghRsp.getAll().size() > 1) {
            throw new IllegalArgumentException("Alternatives are currently not yet supported for GPX");
        }
        long time = timeString != null ? Long.parseLong(timeString) : System.currentTimeMillis();
        InstructionList instructions = ghRsp.getBest().getInstructions();
        return Response.ok((Object)GpxFromInstructions.createGPX((InstructionList)instructions, (String)trackName, (long)time, (boolean)enableElevation, (boolean)withRoute, (boolean)withTrack, (boolean)withWayPoints, (String)version, (Translation)instructions.getTr()), (String)"application/gpx+xml").header("Content-Disposition", (Object)"attachment;filename=GraphHopper.gpx");
    }

    static void initHints(HintsMap m, MultivaluedMap<String, String> parameterMap) {
        for (Map.Entry e : parameterMap.entrySet()) {
            if (((List)e.getValue()).size() != 1) continue;
            m.put((String)e.getKey(), ((List)e.getValue()).get(0));
        }
    }
}

