/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.MultiException;
import com.graphhopper.config.Profile;
import com.graphhopper.http.WebHelper;
import com.graphhopper.jackson.CustomRequest;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="route-custom")
public class CustomWeightingRouteResource {
    private static final Logger logger = LoggerFactory.getLogger(CustomWeightingRouteResource.class);
    private final GraphHopper graphHopper;

    @Inject
    public CustomWeightingRouteResource(GraphHopper graphHopper) {
        this.graphHopper = graphHopper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@NotNull CustomRequest request, @Context HttpServletRequest httpReq) {
        StopWatch sw = new StopWatch().start();
        CustomModel model = request.getModel();
        if (model == null) {
            throw new IllegalArgumentException("No custom model properties found");
        }
        if (request.getHints().has("block_area")) {
            throw new IllegalArgumentException("Instead of block_area define the geometry under 'areas' as GeoJSON and use 'area_<id>: 0' in e.g. priority");
        }
        if (!request.getHints().getBool("ch.disable", true)) {
            throw new IllegalArgumentException("Custom requests are not available for speed mode, do not use ch.disable=false");
        }
        if (Helper.isEmpty((String)request.getProfile())) {
            throw new IllegalArgumentException("The 'profile' parameter for CustomRequest is required");
        }
        Profile profile = this.graphHopper.getProfile(request.getProfile());
        if (profile == null) {
            throw new IllegalArgumentException("profile '" + request.getProfile() + "' not found");
        }
        if (!(profile instanceof CustomProfile)) {
            throw new IllegalArgumentException("profile '" + request.getProfile() + "' cannot be used for a custom request because it has weighting=" + profile.getWeighting());
        }
        GHResponse ghResponse = new GHResponse();
        request.putHint("ch.disable", (Object)true);
        request.putHint("custom_model", (Object)model);
        this.graphHopper.calcPaths((GHRequest)request, ghResponse);
        boolean instructions = request.getHints().getBool("instructions", true);
        boolean enableElevation = request.getHints().getBool("elevation", false);
        boolean calcPoints = request.getHints().getBool("calc_points", true);
        boolean pointsEncoded = request.getHints().getBool("points_encoded", true);
        long took = sw.stop().getNanos() / 1000000L;
        String infoStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent");
        String queryString = httpReq.getQueryString() == null ? "" : httpReq.getQueryString() + " ";
        String logStr = queryString + infoStr + " " + request.getPoints().size() + ", took: " + String.format("%.1f", took) + " ms, algo: " + request.getAlgorithm() + ", profile: " + request.getProfile() + ", custom_model=" + model;
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + ghResponse.getErrors());
            throw new MultiException(ghResponse.getErrors());
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().getSize() + ", debugInfo: " + ghResponse.getDebugInfo());
        return Response.ok((Object)WebHelper.jsonObject((GHResponse)ghResponse, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (float)took)).header("X-GH-Took", (Object)("" + Math.round(took * 1000L))).build();
    }
}

