/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ProfileResolver;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import io.dropwizard.jersey.params.LongParam;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="spt")
public class SPTResource {
    private static final Logger logger = LoggerFactory.getLogger(SPTResource.class);
    private final GraphHopper graphHopper;
    private final ProfileResolver profileResolver;
    private final EncodingManager encodingManager;

    @Inject
    public SPTResource(GraphHopper graphHopper, ProfileResolver profileResolver, EncodingManager encodingManager) {
        this.graphHopper = graphHopper;
        this.profileResolver = profileResolver;
        this.encodingManager = encodingManager;
    }

    @GET
    @Produces(value={"text/csv", "application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="profile") String profileName, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") @NotNull GHPointParam point, @QueryParam(value="columns") String columnsParam, @QueryParam(value="time_limit") @DefaultValue(value="600") LongParam timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") LongParam distanceInMeter) {
        StopWatch sw = new StopWatch().start();
        PMap hintsMap = new PMap();
        RouteResource.initHints(hintsMap, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", (Object)true);
        hintsMap.putObject("lm.disable", (Object)true);
        if (Helper.isEmpty((String)profileName)) {
            profileName = this.profileResolver.resolveProfile(hintsMap).getName();
            hintsMap.remove("weighting");
            hintsMap.remove("vehicle");
        }
        RouteResource.errorIfLegacyParameters(hintsMap);
        Profile profile = this.graphHopper.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist");
        }
        FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges((FlagEncoder)encoder);
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        QueryResult qr = locationIndex.findClosest(((GHPoint)point.get()).lat, ((GHPoint)point.get()).lon, (EdgeFilter)edgeFilter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Point not found:" + (Object)((Object)point));
        }
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        QueryGraph queryGraph = QueryGraph.create((Graph)graph, (QueryResult)qr);
        NodeAccess nodeAccess = queryGraph.getNodeAccess();
        Weighting weighting = this.graphHopper.createWeighting(profile, hintsMap);
        if (hintsMap.has("block_area")) {
            weighting = new BlockAreaWeighting(weighting, GraphEdgeIdFinder.createBlockArea((Graph)graph, (LocationIndex)locationIndex, Collections.singletonList(point.get()), (PMap)hintsMap, (EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)encoder)));
        }
        TraversalMode traversalMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
        ShortestPathTree shortestPathTree = new ShortestPathTree((Graph)queryGraph, weighting, reverseFlow, traversalMode);
        if ((Long)distanceInMeter.get() > 0L) {
            shortestPathTree.setDistanceLimit((double)((Long)distanceInMeter.get()).longValue());
        } else {
            double limit = (Long)timeLimitInSeconds.get() * 1000L;
            shortestPathTree.setTimeLimit(limit);
        }
        String COL_SEP = ",";
        String LINE_SEP = "\n";
        List<String> columns = !Helper.isEmpty((String)columnsParam) ? Arrays.asList(columnsParam.split(",")) : Arrays.asList("longitude", "latitude", "time", "distance");
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Either omit the columns parameter or specify the columns via comma separated values");
        }
        HashMap<String, EncodedValue> pathDetails = new HashMap<String, EncodedValue>();
        for (String col : columns) {
            if (!this.encodingManager.hasEncodedValue(col)) continue;
            pathDetails.put(col, this.encodingManager.getEncodedValue(col, EncodedValue.class));
        }
        StreamingOutput out = output -> {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, Helper.UTF_CS));){
                StringBuilder sb = new StringBuilder();
                for (String col : columns) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(col);
                }
                sb.append("\n");
                writer.write(sb.toString());
                shortestPathTree.search(qr.getClosestNode(), l -> {
                    IsoLabelWithCoordinates label = this.isoLabelWithCoordinates(nodeAccess, (ShortestPathTree.IsoLabel)l);
                    sb.setLength(0);
                    block30: for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
                        String col = (String)columns.get(colIndex);
                        if (colIndex > 0) {
                            sb.append(",");
                        }
                        switch (col) {
                            case "node_id": {
                                sb.append(label.nodeId);
                                continue block30;
                            }
                            case "prev_node_id": {
                                sb.append(label.prevNodeId);
                                continue block30;
                            }
                            case "edge_id": {
                                sb.append(label.edgeId);
                                continue block30;
                            }
                            case "prev_edge_id": {
                                sb.append(label.prevEdgeId);
                                continue block30;
                            }
                            case "distance": {
                                sb.append(label.distance);
                                continue block30;
                            }
                            case "prev_distance": {
                                sb.append(label.prevCoordinate == null ? 0 : label.prevDistance);
                                continue block30;
                            }
                            case "time": {
                                sb.append(label.timeMillis);
                                continue block30;
                            }
                            case "prev_time": {
                                sb.append(label.prevCoordinate == null ? 0 : label.prevTimeMillis);
                                continue block30;
                            }
                            case "longitude": {
                                sb.append(label.coordinate.lon);
                                continue block30;
                            }
                            case "prev_longitude": {
                                sb.append(label.prevCoordinate == null ? null : Double.valueOf(label.prevCoordinate.lon));
                                continue block30;
                            }
                            case "latitude": {
                                sb.append(label.coordinate.lat);
                                continue block30;
                            }
                            case "prev_latitude": {
                                sb.append(label.prevCoordinate == null ? null : Double.valueOf(label.prevCoordinate.lat));
                                continue block30;
                            }
                            default: {
                                EnumEncodedValue eev;
                                EdgeIteratorState edge;
                                if (!EdgeIterator.Edge.isValid((int)label.edgeId) || (edge = queryGraph.getEdgeIteratorState(label.edgeId, label.nodeId)) == null) continue block30;
                                if (col.equals("street_name")) {
                                    sb.append(edge.getName().replaceAll(",", ""));
                                    continue block30;
                                }
                                EncodedValue ev = (EncodedValue)pathDetails.get(col);
                                if (ev instanceof DecimalEncodedValue) {
                                    DecimalEncodedValue dev = (DecimalEncodedValue)ev;
                                    sb.append(reverseFlow ? edge.getReverse(dev) : edge.get(dev));
                                    continue block30;
                                }
                                if (ev instanceof EnumEncodedValue) {
                                    eev = (EnumEncodedValue)ev;
                                    sb.append(reverseFlow ? edge.getReverse(eev) : edge.get(eev));
                                    continue block30;
                                }
                                if (ev instanceof BooleanEncodedValue) {
                                    eev = (BooleanEncodedValue)ev;
                                    sb.append(reverseFlow ? edge.getReverse((BooleanEncodedValue)eev) : edge.get((BooleanEncodedValue)eev));
                                    continue block30;
                                }
                                if (ev instanceof IntEncodedValue) {
                                    eev = (IntEncodedValue)ev;
                                    sb.append(reverseFlow ? edge.getReverse((IntEncodedValue)eev) : edge.get((IntEncodedValue)eev));
                                    continue block30;
                                }
                                throw new IllegalArgumentException("Unknown property " + col);
                            }
                        }
                    }
                    sb.append("\n");
                    try {
                        writer.write(sb.toString());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                });
                logger.info("took: " + sw.stop().getSeconds() + ", visited nodes:" + shortestPathTree.getVisitedNodes() + ", " + uriInfo.getQueryParameters());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return Response.ok((Object)out).type("text/csv").build();
    }

    private IsoLabelWithCoordinates isoLabelWithCoordinates(NodeAccess na, ShortestPathTree.IsoLabel label) {
        double lat = na.getLatitude(label.node);
        double lon = na.getLongitude(label.node);
        IsoLabelWithCoordinates isoLabelWC = new IsoLabelWithCoordinates();
        isoLabelWC.nodeId = label.node;
        isoLabelWC.coordinate = new GHPoint(lat, lon);
        isoLabelWC.timeMillis = Math.round(label.time);
        isoLabelWC.distance = (int)Math.round(label.distance);
        isoLabelWC.edgeId = label.edge;
        if (label.parent != null) {
            ShortestPathTree.IsoLabel prevLabel = label.parent;
            int prevNodeId = prevLabel.node;
            double prevLat = na.getLatitude(prevNodeId);
            double prevLon = na.getLongitude(prevNodeId);
            isoLabelWC.prevNodeId = prevNodeId;
            isoLabelWC.prevEdgeId = prevLabel.edge;
            isoLabelWC.prevCoordinate = new GHPoint(prevLat, prevLon);
            isoLabelWC.prevDistance = (int)Math.round(prevLabel.distance);
            isoLabelWC.prevTimeMillis = Math.round(prevLabel.time);
        }
        return isoLabelWC;
    }

    public static class IsoLabelWithCoordinates {
        public int nodeId = -1;
        public int edgeId;
        public int prevEdgeId;
        public int prevNodeId = -1;
        public int timeMillis;
        public int prevTimeMillis;
        public int distance;
        public int prevDistance;
        public GHPoint coordinate;
        public GHPoint prevCoordinate;
    }
}

