/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GraphHopper;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IGeometryFilter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.TileGeomResult;
import com.wdtinc.mapbox_vector_tile.adapt.jts.UserDataKeyValueMapConverter;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerBuild;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerParams;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="mvt")
public class MVTResource {
    private static final Logger logger = LoggerFactory.getLogger(MVTResource.class);
    private static final MediaType PBF = new MediaType("application", "x-protobuf");
    private final GraphHopper graphHopper;
    private final EncodingManager encodingManager;

    @Inject
    public MVTResource(GraphHopper graphHopper, EncodingManager encodingManager) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
    }

    @GET
    @Path(value="{z}/{x}/{y}.mvt")
    @Produces(value={"application/x-protobuf"})
    public Response doGetXyz(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, final @PathParam(value="z") int zInfo, @PathParam(value="x") int xInfo, @PathParam(value="y") int yInfo, final @QueryParam(value="details") List<String> pathDetails) {
        if (zInfo <= 9) {
            VectorTile.Tile.Builder mvtBuilder = VectorTile.Tile.newBuilder();
            return Response.fromResponse((Response)Response.ok((Object)mvtBuilder.build().toByteArray(), (MediaType)PBF).build()).header("X-GH-Took", (Object)"0").build();
        }
        StopWatch totalSW = new StopWatch().start();
        Coordinate nw = this.num2deg(xInfo, yInfo, zInfo);
        Coordinate se = this.num2deg(xInfo + 1, yInfo + 1, zInfo);
        LocationIndexTree locationIndex = (LocationIndexTree)this.graphHopper.getLocationIndex();
        final NodeAccess na = this.graphHopper.getGraphHopperStorage().getNodeAccess();
        EdgeExplorer edgeExplorer = this.graphHopper.getGraphHopperStorage().createEdgeExplorer(DefaultEdgeFilter.ALL_EDGES);
        BBox bbox = new BBox(nw.x, se.x, se.y, nw.y);
        if (!bbox.isValid()) {
            throw new IllegalStateException("Invalid bbox " + bbox);
        }
        final GeometryFactory geometryFactory = new GeometryFactory();
        VectorTile.Tile.Builder mvtBuilder = VectorTile.Tile.newBuilder();
        final IGeometryFilter acceptAllGeomFilter = geometry -> true;
        final Envelope tileEnvelope = new Envelope(se, nw);
        final MvtLayerParams layerParams = new MvtLayerParams(256, 4096);
        final UserDataKeyValueMapConverter converter = new UserDataKeyValueMapConverter();
        if (!this.encodingManager.hasEncodedValue("road_class")) {
            throw new IllegalStateException("You need to configure GraphHopper to store road_class, e.g. graph.encoded_values: road_class,max_speed,... ");
        }
        final EnumEncodedValue roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        final AtomicInteger edgeCounter = new AtomicInteger(0);
        final MvtLayerProps layerProps = new MvtLayerProps();
        final VectorTile.Tile.Layer.Builder layerBuilder = MvtLayerBuild.newLayerBuilder((String)"roads", (MvtLayerParams)layerParams);
        locationIndex.query(bbox, (LocationIndex.Visitor)new LocationIndex.EdgeVisitor(edgeExplorer){

            public void onEdge(EdgeIteratorState edge, int nodeA, int nodeB) {
                LineString lineString;
                RoadClass rc = (RoadClass)edge.get(roadClassEnc);
                if (zInfo >= 14) {
                    PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
                    lineString = pl.toLineString(false);
                } else if (rc == RoadClass.MOTORWAY || zInfo > 10 && (rc == RoadClass.PRIMARY || rc == RoadClass.TRUNK) || zInfo > 11 && rc == RoadClass.SECONDARY || zInfo > 12) {
                    double lat = na.getLatitude(nodeA);
                    double lon = na.getLongitude(nodeA);
                    double toLat = na.getLatitude(nodeB);
                    double toLon = na.getLongitude(nodeB);
                    lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(lon, lat), new Coordinate(toLon, toLat)});
                } else {
                    return;
                }
                edgeCounter.incrementAndGet();
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("name", edge.getName());
                for (String str : pathDetails) {
                    if (str.contains(",") || !MVTResource.this.encodingManager.hasEncodedValue(str)) continue;
                    EncodedValue ev = MVTResource.this.encodingManager.getEncodedValue(str, EncodedValue.class);
                    if (ev instanceof EnumEncodedValue) {
                        map.put(ev.getName(), edge.get((EnumEncodedValue)ev).toString());
                        continue;
                    }
                    if (ev instanceof DecimalEncodedValue) {
                        map.put(ev.getName(), edge.get((DecimalEncodedValue)ev));
                        continue;
                    }
                    if (ev instanceof BooleanEncodedValue) {
                        map.put(ev.getName(), edge.get((BooleanEncodedValue)ev));
                        continue;
                    }
                    if (!(ev instanceof IntEncodedValue)) continue;
                    map.put(ev.getName(), edge.get((IntEncodedValue)ev));
                }
                lineString.setUserData(map);
                TileGeomResult tileGeom = JtsAdapter.createTileGeom((Geometry)lineString, (Envelope)tileEnvelope, (GeometryFactory)geometryFactory, (MvtLayerParams)layerParams, (IGeometryFilter)acceptAllGeomFilter);
                List features = JtsAdapter.toFeatures((Collection)tileGeom.mvtGeoms, (MvtLayerProps)layerProps, (IUserDataConverter)converter);
                layerBuilder.addAllFeatures((Iterable)features);
            }

            public void onTile(BBox bbox, int depth) {
            }
        });
        MvtLayerBuild.writeProps((VectorTile.Tile.Layer.Builder)layerBuilder, (MvtLayerProps)layerProps);
        mvtBuilder.addLayers(layerBuilder.build());
        byte[] bytes = mvtBuilder.build().toByteArray();
        totalSW.stop();
        logger.debug("took: " + totalSW.getSeconds() + ", edges:" + edgeCounter.get());
        return Response.ok((Object)bytes, (MediaType)PBF).header("X-GH-Took", (Object)("" + totalSW.getSeconds() * 1000.0f)).build();
    }

    Coordinate num2deg(int xInfo, int yInfo, int zoom) {
        double n = Math.pow(2.0, zoom);
        double lonDeg = (double)xInfo / n * 360.0 - 180.0;
        double latRad = Math.atan(Math.sinh(Math.PI * (1.0 - (double)(2 * yInfo) / n)));
        double latDeg = Math.toDegrees(latRad);
        return new Coordinate(lonDeg, latDeg);
    }
}

