/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.conveyal.gtfs.GTFSFeed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.http.FeedConfiguration;
import com.graphhopper.http.RealtimeBundleConfiguration;
import com.graphhopper.storage.GraphHopperStorage;
import io.dropwizard.lifecycle.Managed;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.glassfish.hk2.api.Factory;

public class RealtimeFeedLoadingCache
implements Factory<RealtimeFeed>,
Managed {
    private final HttpClient httpClient;
    private final GraphHopperStorage graphHopperStorage;
    private final GtfsStorage gtfsStorage;
    private final RealtimeBundleConfiguration bundleConfiguration;
    private ExecutorService executor;
    private LoadingCache<String, RealtimeFeed> cache;
    private Map<String, Transfers> transfers;

    @Inject
    RealtimeFeedLoadingCache(GraphHopperStorage graphHopperStorage, GtfsStorage gtfsStorage, HttpClient httpClient, RealtimeBundleConfiguration bundleConfiguration) {
        this.graphHopperStorage = graphHopperStorage;
        this.gtfsStorage = gtfsStorage;
        this.bundleConfiguration = bundleConfiguration;
        this.httpClient = httpClient;
    }

    public void start() {
        this.transfers = new HashMap<String, Transfers>();
        for (Map.Entry entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
            this.transfers.put((String)entry.getKey(), new Transfers((GTFSFeed)entry.getValue()));
        }
        this.executor = Executors.newSingleThreadExecutor();
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RealtimeFeed>(){

            public RealtimeFeed load(String key) {
                return RealtimeFeedLoadingCache.this.fetchFeedsAndCreateGraph();
            }

            public ListenableFuture<RealtimeFeed> reload(String key, RealtimeFeed oldValue) {
                ListenableFutureTask task = ListenableFutureTask.create(() -> RealtimeFeedLoadingCache.this.fetchFeedsAndCreateGraph());
                RealtimeFeedLoadingCache.this.executor.execute((Runnable)task);
                return task;
            }
        });
    }

    public RealtimeFeed provide() {
        try {
            return (RealtimeFeed)this.cache.get((Object)"pups");
        }
        catch (RuntimeException | ExecutionException e) {
            e.printStackTrace();
            return RealtimeFeed.empty();
        }
    }

    public void dispose(RealtimeFeed instance) {
        this.executor.shutdown();
    }

    public void stop() {
    }

    private RealtimeFeed fetchFeedsAndCreateGraph() {
        HashMap<String, GtfsRealtime.FeedMessage> feedMessageMap = new HashMap<String, GtfsRealtime.FeedMessage>();
        for (FeedConfiguration configuration : this.bundleConfiguration.gtfsrealtime().getFeeds()) {
            try {
                GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom((InputStream)this.httpClient.execute((HttpUriRequest)new HttpGet(configuration.getUrl().toURI())).getEntity().getContent());
                feedMessageMap.put(configuration.getFeedId(), feedMessage);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return RealtimeFeed.fromProtobuf((GraphHopperStorage)this.graphHopperStorage, (GtfsStorage)this.gtfsStorage, this.transfers, feedMessageMap);
    }
}

