/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtLocationSnapper;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.http.GHLocationParam;
import com.graphhopper.http.OffsetDateTimeParam;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Path(value="isochrone-pt")
public class PtIsochroneResource {
    private static final double JTS_TOLERANCE = 1.0E-5;
    private final GtfsStorage gtfsStorage;
    private final EncodingManager encodingManager;
    private final GraphHopperStorage graphHopperStorage;
    private final LocationIndex locationIndex;

    @Inject
    public PtIsochroneResource(GtfsStorage gtfsStorage, EncodingManager encodingManager, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex) {
        this.gtfsStorage = gtfsStorage;
        this.encodingManager = encodingManager;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@QueryParam(value="point") GHLocationParam sourceParam, @QueryParam(value="time_limit") @DefaultValue(value="600") long seconds, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="pt.earliest_departure_time") @NotNull OffsetDateTimeParam departureTimeParam, @QueryParam(value="pt.blocked_route_types") @DefaultValue(value="0") int blockedRouteTypes, @QueryParam(value="result") @DefaultValue(value="multipolygon") String format) {
        MultiPoint exploredPoints;
        Instant initialTime = ((OffsetDateTime)departureTimeParam.get()).toInstant();
        GHLocation location = (GHLocation)sourceParam.get();
        double targetZ = seconds * 1000L;
        GeometryFactory geometryFactory = new GeometryFactory();
        FlagEncoder footEncoder = this.encodingManager.getEncoder("foot");
        FastestWeighting weighting = new FastestWeighting(footEncoder);
        DefaultSnapFilter snapFilter = new DefaultSnapFilter((Weighting)weighting, this.graphHopperStorage.getEncodingManager().getBooleanEncodedValue(Subnetwork.key((String)"foot")));
        PtLocationSnapper.Result snapResult = new PtLocationSnapper(this.graphHopperStorage, this.locationIndex, this.gtfsStorage).snapAll(Arrays.asList(location), Arrays.asList(snapFilter));
        GraphExplorer graphExplorer = new GraphExplorer((Graph)snapResult.queryGraph, this.gtfsStorage.getPtGraph(), (Weighting)weighting, this.gtfsStorage, RealtimeFeed.empty(), reverseFlow, false, false, 5.0, reverseFlow, blockedRouteTypes);
        MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, reverseFlow, false, false, 0L, Collections.emptyList());
        HashMap<Coordinate, Double> z1 = new HashMap<Coordinate, Double>();
        NodeAccess nodeAccess = snapResult.queryGraph.getNodeAccess();
        for (Label label : router.calcLabels((Label.NodeId)snapResult.nodes.get(0), initialTime)) {
            long l = label.currentTime - initialTime.toEpochMilli();
            int n = reverseFlow ? -1 : 1;
            if (!((double)(l * (long)n) <= targetZ)) break;
            if (label.node.streetNode != -1) {
                Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLon(label.node.streetNode), nodeAccess.getLat(label.node.streetNode));
                z1.merge(nodeCoordinate, (double)(label.currentTime - initialTime.toEpochMilli()) * (double)(reverseFlow ? -1 : 1), Math::min);
                continue;
            }
            if (label.edge == null || label.edge.getType() != GtfsStorage.EdgeType.EXIT_PT && label.edge.getType() != GtfsStorage.EdgeType.ENTER_PT) continue;
            GtfsStorage.PlatformDescriptor platformDescriptor = label.edge.getPlatformDescriptor();
            Iterator stop = (Stop)((GTFSFeed)this.gtfsStorage.getGtfsFeeds().get((Object)platformDescriptor.feed_id)).stops.get(platformDescriptor.stop_id);
            Coordinate nodeCoordinate = new Coordinate(((Stop)stop).stop_lon, ((Stop)stop).stop_lat);
            z1.merge(nodeCoordinate, (double)(label.currentTime - initialTime.toEpochMilli()) * (double)(reverseFlow ? -1 : 1), Math::min);
        }
        if (format.equals("multipoint")) {
            exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
            return this.wrap((Geometry)exploredPoints);
        }
        exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        this.locationIndex.query(BBox.fromEnvelope((Envelope)exploredPoints.getEnvelopeInternal()), edgeId -> {
            EdgeIteratorState edge = snapResult.queryGraph.getEdgeIteratorStateForKey(edgeId * 2);
            z1.merge(new Coordinate(nodeAccess.getLon(edge.getBaseNode()), nodeAccess.getLat(edge.getBaseNode())), (Double)Double.MAX_VALUE, Math::min);
            z1.merge(new Coordinate(nodeAccess.getLon(edge.getAdjNode()), nodeAccess.getLat(edge.getAdjNode())), (Double)Double.MAX_VALUE, Math::min);
        });
        exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        CoordinateList siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates((Geometry)exploredPoints);
        ArrayList<ConstraintVertex> constraintVertices = new ArrayList<ConstraintVertex>();
        for (Object siteCoord : siteCoords) {
            Coordinate coord = (Coordinate)siteCoord;
            constraintVertices.add(new ConstraintVertex(coord));
        }
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(constraintVertices, 1.0E-5);
        cdt.setConstraints(new ArrayList(), new ArrayList());
        cdt.formInitialDelaunay();
        QuadEdgeSubdivision tin = cdt.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (tin.isFrameVertex(vertex)) {
                vertex.setZ(Double.MAX_VALUE);
                continue;
            }
            Double aDouble = (Double)z1.get(vertex.getCoordinate());
            if (aDouble != null) {
                vertex.setZ(aDouble.doubleValue());
                continue;
            }
            vertex.setZ(Double.MAX_VALUE);
        }
        ReadableTriangulation triangulation = ReadableTriangulation.wrap((QuadEdgeSubdivision)tin);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation);
        MultiPolygon isoline = contourBuilder.computeIsoline(targetZ, triangulation.getEdges());
        if (format.equals("triangulation")) {
            HashMap<String, Double> properties;
            JsonFeature feature;
            Response response = new Response();
            for (Vertex vertex : tin.getVertices(true)) {
                feature = new JsonFeature();
                feature.setGeometry((Geometry)geometryFactory.createPoint(vertex.getCoordinate()));
                properties = new HashMap<String, Double>();
                properties.put("z", vertex.getZ());
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            for (QuadEdge edge : tin.getPrimaryEdges(false)) {
                feature = new JsonFeature();
                feature.setGeometry((Geometry)edge.toLineSegment().toGeometry(geometryFactory));
                properties = new HashMap();
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            JsonFeature feature2 = new JsonFeature();
            feature2.setGeometry((Geometry)isoline);
            HashMap<String, Double> properties2 = new HashMap<String, Double>();
            properties2.put("z", targetZ);
            feature2.setProperties(properties2);
            response.polygons.add(feature2);
            response.info.copyrights.addAll(ResponsePathSerializer.COPYRIGHTS);
            return response;
        }
        return this.wrap((Geometry)isoline);
    }

    private Response wrap(Geometry isoline) {
        JsonFeature feature = new JsonFeature();
        feature.setGeometry(isoline);
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("bucket", 0);
        feature.setProperties(properties);
        Response response = new Response();
        response.polygons.add(feature);
        response.info.copyrights.addAll(ResponsePathSerializer.COPYRIGHTS);
        return response;
    }

    public static class Response {
        public List<JsonFeature> polygons = new ArrayList<JsonFeature>();
        public Info info = new Info();

        public static class Info {
            public List<String> copyrights = new ArrayList<String>();
        }
    }
}

