/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.gpx.GpxConversions;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.jackson.Gpx;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.State;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.Constants;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RamerDouglasPeucker;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="match")
public class MapMatchingResource {
    private static final Logger logger = LoggerFactory.getLogger(MapMatchingResource.class);
    private final GraphHopper graphHopper;
    private final ProfileResolver profileResolver;
    private final TranslationMap trMap;
    private final MapMatchingRouterFactory mapMatchingRouterFactory;
    private final ObjectMapper objectMapper = Jackson.newObjectMapper();

    @Inject
    public MapMatchingResource(GraphHopper graphHopper, ProfileResolver profileResolver, TranslationMap trMap, MapMatchingRouterFactory mapMatchingRouterFactory) {
        this.graphHopper = graphHopper;
        this.profileResolver = profileResolver;
        this.trMap = trMap;
        this.mapMatchingRouterFactory = mapMatchingRouterFactory;
    }

    @POST
    @Consumes(value={"application/xml", "application/gpx+xml"})
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response match(Gpx gpx, @Context UriInfo uriInfo, @QueryParam(value="way_point_max_distance") @DefaultValue(value="1") double minPathPrecision, @QueryParam(value="type") @DefaultValue(value="json") String outType, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="profile") String profile, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="traversal_keys") @DefaultValue(value="false") boolean enableTraversalKeys, @QueryParam(value="gps_accuracy") @DefaultValue(value="40") double gpsAccuracy, @QueryParam(value="max_visited_nodes") @DefaultValue(value="3000") int maxVisitedNodes) {
        boolean writeGPX = "gpx".equalsIgnoreCase(outType);
        if (gpx.trk.isEmpty()) {
            throw new IllegalArgumentException("No tracks found in GPX document. Are you using waypoints or routes instead?");
        }
        if (gpx.trk.size() > 1) {
            throw new IllegalArgumentException("GPX documents with multiple tracks not supported yet.");
        }
        instructions = writeGPX || instructions;
        StopWatch sw = new StopWatch().start();
        PMap hints = new PMap();
        RouteResource.initHints(hints, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        hints.putObject("max_visited_nodes", (Object)maxVisitedNodes);
        PMap profileResolverHints = new PMap(hints);
        profileResolverHints.putObject("profile", (Object)profile);
        profileResolverHints.putObject("ch.disable", (Object)true);
        profile = this.profileResolver.resolveProfile(profileResolverHints);
        hints.putObject("profile", (Object)profile);
        RouteResource.removeLegacyParameters(hints);
        MapMatching matching = new MapMatching(this.graphHopper.getBaseGraph(), (LocationIndexTree)this.graphHopper.getLocationIndex(), this.mapMatchingRouterFactory.createMapMatchingRouter(hints));
        matching.setMeasurementErrorSigma(gpsAccuracy);
        List<Observation> measurements = GpxConversions.getEntries((Gpx.Trk)gpx.trk.get(0));
        MatchResult matchResult = matching.match(measurements);
        sw.stop();
        logger.info(this.objectMapper.createObjectNode().put("duration", sw.getNanos()).put("profile", profile).put("observations", measurements.size()).putPOJO("mapmatching", (Object)matching.getStatistics()).toString());
        if ("extended_json".equals(outType)) {
            return Response.ok((Object)MapMatchingResource.convertToTree(matchResult, enableElevation, pointsEncoded)).header("X-GH-Took", (Object)("" + Math.round(sw.getMillisDouble()))).build();
        }
        Translation tr = this.trMap.getWithFallBack(Helper.getLocale((String)localeStr));
        RamerDouglasPeucker simplifyAlgo = new RamerDouglasPeucker().setMaxDistance(minPathPrecision);
        PathMerger pathMerger = new PathMerger(matchResult.getGraph(), matchResult.getWeighting()).setEnableInstructions(instructions).setPathDetailsBuilders(this.graphHopper.getPathDetailsBuilderFactory(), pathDetails).setRamerDouglasPeucker(simplifyAlgo).setSimplifyResponse(minPathPrecision > 0.0);
        ResponsePath responsePath = pathMerger.doWork(PointList.EMPTY, Collections.singletonList(matchResult.getMergedPath()), (EncodedValueLookup)this.graphHopper.getEncodingManager(), tr);
        responsePath.getErrors().clear();
        GHResponse rsp = new GHResponse();
        rsp.add(responsePath);
        if (writeGPX) {
            long time = ((Gpx.Trk)gpx.trk.get(0)).getStartTime().map(Date::getTime).orElse(System.currentTimeMillis());
            return Response.ok((Object)GpxConversions.createGPX(rsp.getBest().getInstructions(), ((Gpx.Trk)gpx.trk.get((int)0)).name != null ? ((Gpx.Trk)gpx.trk.get((int)0)).name : "", time, enableElevation, withRoute, withTrack, false, Constants.VERSION, tr), (String)"application/gpx+xml").header("X-GH-Took", (Object)("" + Math.round(sw.getMillisDouble()))).build();
        }
        ObjectNode map = ResponsePathSerializer.jsonObject((GHResponse)rsp, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (double)sw.getMillisDouble());
        HashMap<String, Number> matchStatistics = new HashMap<String, Number>();
        matchStatistics.put("distance", matchResult.getMatchLength());
        matchStatistics.put("time", matchResult.getMatchMillis());
        matchStatistics.put("original_distance", matchResult.getGpxEntriesLength());
        map.putPOJO("map_matching", matchStatistics);
        if (enableTraversalKeys) {
            ArrayList<Integer> traversalKeylist = new ArrayList<Integer>();
            for (EdgeMatch em : matchResult.getEdgeMatches()) {
                EdgeIteratorState edge = em.getEdgeState();
                traversalKeylist.add(edge.getEdgeKey());
            }
            map.putPOJO("traversal_keys", traversalKeylist);
        }
        return Response.ok((Object)map).header("X-GH-Took", (Object)("" + Math.round(sw.getMillisDouble()))).build();
    }

    public static JsonNode convertToTree(MatchResult result, boolean elevation, boolean pointsEncoded) {
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode diary = root.putObject("diary");
        ArrayNode entries = diary.putArray("entries");
        ObjectNode route = entries.addObject();
        ArrayNode links = route.putArray("links");
        for (int emIndex = 0; emIndex < result.getEdgeMatches().size(); ++emIndex) {
            ObjectNode link = links.addObject();
            EdgeMatch edgeMatch = (EdgeMatch)result.getEdgeMatches().get(emIndex);
            PointList pointList = edgeMatch.getEdgeState().fetchWayGeometry(emIndex == 0 ? FetchMode.ALL : FetchMode.PILLAR_AND_ADJ);
            ObjectNode geometry = link.putObject("geometry");
            if (pointList.size() < 2) {
                geometry.putPOJO("coordinates", (Object)(pointsEncoded ? ResponsePathSerializer.encodePolyline((PointList)pointList, (boolean)elevation, (double)100000.0) : pointList.toLineString(elevation)));
                geometry.put("type", "Point");
            } else {
                geometry.putPOJO("coordinates", (Object)(pointsEncoded ? ResponsePathSerializer.encodePolyline((PointList)pointList, (boolean)elevation, (double)100000.0) : pointList.toLineString(elevation)));
                geometry.put("type", "LineString");
            }
            link.put("id", edgeMatch.getEdgeState().getEdge());
            ArrayNode wpts = link.putArray("wpts");
            for (State extension : edgeMatch.getStates()) {
                ObjectNode wpt = wpts.addObject();
                wpt.put("x", extension.getSnap().getSnappedPoint().lon);
                wpt.put("y", extension.getSnap().getSnappedPoint().lat);
            }
        }
        return root;
    }

    public static interface MapMatchingRouterFactory {
        public MapMatching.Router createMapMatchingRouter(PMap var1);
    }
}

