/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import io.dropwizard.lifecycle.Managed;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopperManaged.class);
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration) {
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopper();
        String customModelFolder = configuration.getString("custom_model_folder", "");
        List<Profile> newProfiles = GraphHopperManaged.resolveCustomModelFiles(customModelFolder, configuration.getProfiles());
        configuration.setProfiles(newProfiles);
        this.graphHopper.init(configuration);
    }

    public static List<Profile> resolveCustomModelFiles(String customModelFolder, List<Profile> profiles) {
        ObjectMapper jsonOM = Jackson.newObjectMapper();
        ArrayList<Profile> newProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            if (!"custom".equals(profile.getWeighting())) {
                newProfiles.add(profile);
                continue;
            }
            Object cm = profile.getHints().getObject("custom_model", null);
            if (cm != null) {
                try {
                    CustomModel customModel = (CustomModel)jsonOM.readValue(jsonOM.writeValueAsBytes(cm), CustomModel.class);
                    newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(customModel));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from " + cm + " for profile " + profile.getName() + ". If you are trying to load from a file, use 'custom_model_file' instead.", ex);
                }
            }
            String customModelFileName = profile.getHints().getString("custom_model_file", "");
            if (customModelFileName.isEmpty()) {
                throw new IllegalArgumentException("Missing 'custom_model' or 'custom_model_file' field in profile '" + profile.getName() + "'. To use default specify custom_model_file: empty");
            }
            if ("empty".equals(customModelFileName)) {
                newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(new CustomModel()));
                continue;
            }
            if (customModelFileName.contains(File.separator)) {
                throw new IllegalArgumentException("Use custom_model_folder for the custom_model_file parent");
            }
            if (!customModelFileName.endsWith(".json")) {
                throw new IllegalArgumentException("Yaml is no longer supported, see #2672. Use JSON with optional comments //");
            }
            try {
                String string = Helper.readJSONFileWithoutComments((String)Paths.get(customModelFolder, new String[0]).resolve(customModelFileName).toFile().getAbsolutePath());
                CustomModel customModel = (CustomModel)jsonOM.readValue(string, CustomModel.class);
                newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(customModel));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load custom_model from location " + customModelFileName + " for profile " + profile.getName(), ex);
            }
        }
        return newProfiles;
    }

    public void start() {
        this.graphHopper.importOrLoad();
        logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {} ints for edge flags, {}", new Object[]{this.graphHopper.getGraphHopperLocation(), this.graphHopper.getOSMFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getEncodingManager().getIntsForFlags(), this.graphHopper.getBaseGraph().toDetailsString()});
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

