/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FiniteWeightFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.ToDoubleFunction;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hibernate.validator.constraints.Range;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopper graphHopper;
    private final Triangulator triangulator;
    private final ProfileResolver profileResolver;

    @Inject
    public IsochroneResource(GraphHopper graphHopper, Triangulator triangulator, ProfileResolver profileResolver) {
        this.graphHopper = graphHopper;
        this.triangulator = triangulator;
        this.profileResolver = profileResolver;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="profile") String profileName, @QueryParam(value="buckets") @Range(min=1L, max=20L) @DefaultValue(value="1") @Range(min=1L, max=20L) OptionalInt nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") @NotNull GHPointParam point, @QueryParam(value="time_limit") @DefaultValue(value="600") OptionalLong timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") OptionalLong distanceLimitInMeter, @QueryParam(value="weight_limit") @DefaultValue(value="-1") OptionalLong weightLimit, @QueryParam(value="type") @DefaultValue(value="json") ResponseType respType, @QueryParam(value="tolerance") @DefaultValue(value="0") double toleranceInMeter, @QueryParam(value="full_geometry") @DefaultValue(value="false") boolean fullGeometry) {
        void var36_42;
        ToDoubleFunction<ShortestPathTree.IsoLabel> fz;
        double limit;
        Snap snap;
        StopWatch sw = new StopWatch().start();
        PMap hintsMap = new PMap();
        RouteResource.initHints(hintsMap, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", (Object)true);
        hintsMap.putObject("lm.disable", (Object)true);
        PMap profileResolverHints = new PMap(hintsMap);
        profileResolverHints.putObject("profile", (Object)profileName);
        profileName = this.profileResolver.resolveProfile(profileResolverHints);
        RouteResource.removeLegacyParameters(hintsMap);
        Profile profile = this.graphHopper.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist");
        }
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        BaseGraph graph = this.graphHopper.getBaseGraph();
        Weighting weighting = this.graphHopper.createWeighting(profile, hintsMap);
        BooleanEncodedValue inSubnetworkEnc = this.graphHopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key((String)profileName));
        if (hintsMap.has("block_area")) {
            GraphEdgeIdFinder.BlockArea blockArea = GraphEdgeIdFinder.createBlockArea((Graph)graph, (LocationIndex)locationIndex, Collections.singletonList(point.get()), (PMap)hintsMap, (EdgeFilter)new FiniteWeightFilter(weighting));
            weighting = new BlockAreaWeighting(weighting, blockArea);
        }
        if (!(snap = locationIndex.findClosest(((GHPoint)point.get()).lat, ((GHPoint)point.get()).lon, (EdgeFilter)new DefaultSnapFilter(weighting, inSubnetworkEnc))).isValid()) {
            throw new IllegalArgumentException("Point not found:" + (Object)((Object)point));
        }
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, (Snap)snap);
        TraversalMode traversalMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
        ShortestPathTree shortestPathTree = new ShortestPathTree((Graph)queryGraph, queryGraph.wrapWeighting(weighting), reverseFlow, traversalMode);
        if (weightLimit.orElseThrow(() -> new IllegalArgumentException("query param weight_limit is not a number.")) > 0L) {
            limit = weightLimit.getAsLong();
            shortestPathTree.setWeightLimit(limit + Math.max(limit * 0.14, 2000.0));
            fz = l -> l.weight;
        } else if (distanceLimitInMeter.orElseThrow(() -> new IllegalArgumentException("query param distance_limit is not a number.")) > 0L) {
            limit = distanceLimitInMeter.getAsLong();
            shortestPathTree.setDistanceLimit(limit + Math.max(limit * 0.14, 2000.0));
            fz = l -> l.distance;
        } else {
            limit = (double)timeLimitInSeconds.orElseThrow(() -> new IllegalArgumentException("query param time_limit is not a number.")) * 1000.0;
            shortestPathTree.setTimeLimit(limit + Math.max(limit * 0.14, 200000.0));
            fz = l -> l.time;
        }
        ArrayList<Double> zs = new ArrayList<Double>();
        double delta = limit / (double)nBuckets.orElseThrow(() -> new IllegalArgumentException("query param buckets is not a number."));
        for (int i = 0; i < nBuckets.getAsInt(); ++i) {
            zs.add((double)(i + 1) * delta);
        }
        Triangulator.Result result = this.triangulator.triangulate(snap, queryGraph, shortestPathTree, fz, IsochroneResource.degreesFromMeters(toleranceInMeter));
        ContourBuilder contourBuilder = new ContourBuilder(result.triangulation);
        ArrayList<Object> isochrones = new ArrayList<Object>();
        for (Double d : zs) {
            logger.info("Building contour z={}", (Object)d);
            MultiPolygon multiPolygon = contourBuilder.computeIsoline(d.doubleValue(), result.seedEdges);
            if (fullGeometry) {
                isochrones.add(multiPolygon);
                continue;
            }
            Polygon maxPolygon = this.heuristicallyFindMainConnectedComponent(multiPolygon, multiPolygon.getFactory().createPoint(new Coordinate(((GHPoint)point.get()).lon, ((GHPoint)point.get()).lat)));
            isochrones.add(multiPolygon.getFactory().createPolygon(maxPolygon.getExteriorRing()));
        }
        ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
        for (Geometry geometry : isochrones) {
            JsonFeature feature = new JsonFeature();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("bucket", features.size());
            if (respType == ResponseType.geojson) {
                properties.put("copyrights", ResponsePathSerializer.COPYRIGHTS);
            }
            feature.setProperties(properties);
            feature.setGeometry(geometry);
            features.add(feature);
        }
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        sw.stop();
        Object var36_39 = null;
        if (respType == ResponseType.geojson) {
            objectNode.put("type", "FeatureCollection");
            objectNode.putPOJO("features", features);
            ObjectNode objectNode2 = objectNode;
        } else {
            objectNode.putPOJO("polygons", features);
            ObjectNode info = objectNode.putObject("info");
            info.putPOJO("copyrights", (Object)ResponsePathSerializer.COPYRIGHTS);
            info.put("took", Math.round(sw.getMillis()));
            ObjectNode objectNode3 = objectNode;
        }
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + shortestPathTree.getVisitedNodes());
        return Response.ok((Object)var36_42).header("X-GH-Took", (Object)("" + sw.getSeconds() * 1000.0f)).build();
    }

    private Polygon heuristicallyFindMainConnectedComponent(MultiPolygon multiPolygon, Point point) {
        int maxPoints = 0;
        Polygon maxPolygon = null;
        for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
            if (polygon.contains((Geometry)point)) {
                return polygon;
            }
            if (polygon.getNumPoints() <= maxPoints) continue;
            maxPoints = polygon.getNumPoints();
            maxPolygon = polygon;
        }
        return maxPolygon;
    }

    static double degreesFromMeters(double distanceInMeters) {
        return distanceInMeters / 111194.92664455873;
    }

    public static enum ResponseType {
        json,
        geojson;

    }
}

