/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GraphHopperGtfs;
import io.dropwizard.lifecycle.Managed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopperManaged.class);
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration) {
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopper();
        this.graphHopper.init(configuration);
    }

    public void start() {
        this.graphHopper.importOrLoad();
        logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {} ints for edge flags, {}", new Object[]{this.graphHopper.getGraphHopperLocation(), this.graphHopper.getOSMFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getEncodingManager().getIntsForFlags(), this.graphHopper.getBaseGraph().toDetailsString()});
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

