/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.gpx.GpxConversions;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.http.GHRequestTransformer;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.jackson.MultiException;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import io.dropwizard.jersey.params.AbstractParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="route")
public class RouteResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteResource.class);
    private final GraphHopper graphHopper;
    private final ProfileResolver profileResolver;
    private final GHRequestTransformer ghRequestTransformer;
    private final Boolean hasElevation;
    private final String osmDate;

    @Inject
    public RouteResource(GraphHopper graphHopper, ProfileResolver profileResolver, GHRequestTransformer ghRequestTransformer, @Named(value="hasElevation") Boolean hasElevation) {
        this.graphHopper = graphHopper;
        this.profileResolver = profileResolver;
        this.ghRequestTransformer = ghRequestTransformer;
        this.hasElevation = hasElevation;
        this.osmDate = graphHopper.getProperties().get("datareader.data.date");
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @QueryParam(value="way_point_max_distance") @DefaultValue(value="1") double minPathPrecision, @QueryParam(value="elevation_way_point_max_distance") Double minPathElevationPrecision, @QueryParam(value="point") @NotNull List<GHPointParam> pointParams, @QueryParam(value="type") @DefaultValue(value="json") String type, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="profile") String profileName, @QueryParam(value="algorithm") @DefaultValue(value="") String algoStr, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="point_hint") List<String> pointHints, @QueryParam(value="curbside") List<String> curbsides, @QueryParam(value="snap_prevention") List<String> snapPreventions, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="heading") @NotNull List<Double> headings, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="gpx.waypoints") @DefaultValue(value="false") boolean withWayPoints, @QueryParam(value="gpx.trackname") @DefaultValue(value="GraphHopper Track") String trackName, @QueryParam(value="gpx.millis") String timeString) {
        StopWatch sw = new StopWatch().start();
        List points = pointParams.stream().map(AbstractParam::get).collect(Collectors.toList());
        boolean writeGPX = "gpx".equalsIgnoreCase(type);
        boolean bl = instructions = writeGPX || instructions;
        if (enableElevation && !this.hasElevation.booleanValue()) {
            throw new IllegalArgumentException("Elevation not supported!");
        }
        GHRequest request = new GHRequest();
        RouteResource.initHints(request.getHints(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        if (minPathElevationPrecision != null) {
            request.getHints().putObject("elevation_way_point_max_distance", (Object)minPathElevationPrecision);
        }
        request.setPoints(points).setProfile(profileName).setAlgorithm(algoStr).setLocale(localeStr).setHeadings(headings).setPointHints(pointHints).setCurbsides(curbsides).setSnapPreventions(snapPreventions).setPathDetails(pathDetails).getHints().putObject("calc_points", (Object)calcPoints).putObject("instructions", (Object)instructions).putObject("way_point_max_distance", (Object)minPathPrecision);
        request = this.ghRequestTransformer.transformRequest(request);
        PMap profileResolverHints = new PMap(request.getHints());
        profileResolverHints.putObject("profile", (Object)profileName);
        profileResolverHints.putObject("has_curbsides", (Object)(!curbsides.isEmpty() ? 1 : 0));
        profileName = this.profileResolver.resolveProfile(profileResolverHints);
        RouteResource.removeLegacyParameters(request.getHints());
        request.setProfile(profileName);
        GHResponse ghResponse = this.graphHopper.route(request);
        double took = sw.stop().getMillisDouble();
        String logStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent") + " " + points + ", took: " + String.format("%.1f", took) + "ms, algo: " + algoStr + ", profile: " + profileName;
        if (ghResponse.hasErrors()) {
            logger.info(logStr + " " + ghResponse);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new MultiException(ghResponse.getErrors())).type(writeGPX ? "application/gpx+xml" : "application/json").build();
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().size() + ", debugInfo: " + ghResponse.getDebugInfo());
        return writeGPX ? RouteResource.gpxSuccessResponseBuilder(ghResponse, timeString, trackName, enableElevation, withRoute, withTrack, withWayPoints, Constants.VERSION).header("X-GH-Took", (Object)("" + Math.round(took))).build() : Response.ok((Object)ResponsePathSerializer.jsonObject((GHResponse)ghResponse, (String)this.osmDate, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (double)took)).header("X-GH-Took", (Object)("" + Math.round(took))).type("application/json").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@NotNull GHRequest request, @Context HttpServletRequest httpReq) {
        StopWatch sw = new StopWatch().start();
        if (Helper.isEmpty((String)(request = this.ghRequestTransformer.transformRequest(request)).getProfile()) && request.getCustomModel() != null) {
            throw new IllegalArgumentException("The 'profile' parameter is required when you use the `custom_model` parameter");
        }
        PMap profileResolverHints = new PMap(request.getHints());
        profileResolverHints.putObject("profile", (Object)request.getProfile());
        profileResolverHints.putObject("has_curbsides", (Object)(!request.getCurbsides().isEmpty() ? 1 : 0));
        request.setProfile(this.profileResolver.resolveProfile(profileResolverHints));
        RouteResource.removeLegacyParameters(request.getHints());
        GHResponse ghResponse = this.graphHopper.route(request);
        boolean instructions = request.getHints().getBool("instructions", true);
        boolean enableElevation = request.getHints().getBool("elevation", false);
        boolean calcPoints = request.getHints().getBool("calc_points", true);
        boolean pointsEncoded = request.getHints().getBool("points_encoded", true);
        double took = sw.stop().getMillisDouble();
        String infoStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent");
        String logStr = infoStr + " " + request.getPoints().size() + ", took: " + String.format("%.1f", took) + " ms, algo: " + request.getAlgorithm() + ", profile: " + request.getProfile() + ", custom_model: " + request.getCustomModel();
        if (ghResponse.hasErrors()) {
            throw new MultiException(ghResponse.getErrors());
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().size() + ", debugInfo: " + ghResponse.getDebugInfo());
        return Response.ok((Object)ResponsePathSerializer.jsonObject((GHResponse)ghResponse, (String)this.osmDate, (boolean)instructions, (boolean)calcPoints, (boolean)enableElevation, (boolean)pointsEncoded, (double)took)).header("X-GH-Took", (Object)("" + Math.round(took))).type("application/json").build();
    }

    public static void removeLegacyParameters(PMap hints) {
        hints.remove("weighting");
        hints.remove("vehicle");
        hints.remove("edge_based");
        hints.remove("turn_costs");
    }

    private static Response.ResponseBuilder gpxSuccessResponseBuilder(GHResponse ghRsp, String timeString, String trackName, boolean enableElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version) {
        if (ghRsp.getAll().size() > 1) {
            throw new IllegalArgumentException("Alternatives are currently not yet supported for GPX");
        }
        long time = timeString != null ? Long.parseLong(timeString) : System.currentTimeMillis();
        InstructionList instructions = ghRsp.getBest().getInstructions();
        return Response.ok((Object)GpxConversions.createGPX(instructions, trackName, time, enableElevation, withRoute, withTrack, withWayPoints, version, instructions.getTr()), (String)"application/gpx+xml").header("Content-Disposition", (Object)"attachment;filename=GraphHopper.gpx");
    }

    static void initHints(PMap m, MultivaluedMap<String, String> parameterMap) {
        for (Map.Entry e : parameterMap.entrySet()) {
            if (((List)e.getValue()).size() != 1) continue;
            m.putObject(Helper.camelCaseToUnderScore((String)((String)e.getKey())), Helper.toObject((String)((String)((List)e.getValue()).get(0))));
        }
    }
}

