/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.locationtech.jts.geom.Envelope;

@Path(value="info")
@Produces(value={"application/json"})
public class InfoResource {
    private final GraphHopperConfig config;
    private final BaseGraph baseGraph;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;
    private final boolean hasElevation;
    private final Set<String> privateEV;

    @Inject
    public InfoResource(GraphHopperConfig config, GraphHopper graphHopper, @Named(value="hasElevation") Boolean hasElevation) {
        this.config = config;
        this.encodingManager = graphHopper.getEncodingManager();
        this.privateEV = new HashSet<String>(Arrays.asList(config.getString("graph.encoded_values.private", "").split(",")));
        for (String pEV : this.privateEV) {
            if (pEV.isEmpty() || this.encodingManager.hasEncodedValue(pEV)) continue;
            throw new IllegalArgumentException("A private encoded value does not exist.");
        }
        this.baseGraph = graphHopper.getBaseGraph();
        this.properties = graphHopper.getProperties();
        this.hasElevation = hasElevation;
    }

    @GET
    public Info getInfo() {
        Info info = new Info();
        info.bbox = new Envelope(this.baseGraph.getBounds().minLon, this.baseGraph.getBounds().maxLon, this.baseGraph.getBounds().minLat, this.baseGraph.getBounds().maxLat);
        for (Profile p : this.config.getProfiles()) {
            Info.ProfileData profileData = new Info.ProfileData(p.getName());
            info.profiles.add(profileData);
        }
        if (this.config.has("gtfs.file")) {
            info.profiles.add(new Info.ProfileData("pt"));
        }
        info.elevation = this.hasElevation;
        info.import_date = this.properties.get("datareader.import.date");
        info.data_date = this.properties.get("datareader.data.date");
        List evList = this.encodingManager.getEncodedValues();
        info.encoded_values = new LinkedHashMap<String, List<Object>>();
        for (EncodedValue encodedValue : evList) {
            ArrayList<String> possibleValueList = new ArrayList<String>();
            String name = encodedValue.getName();
            if (this.privateEV.contains(name)) continue;
            if (encodedValue instanceof EnumEncodedValue) {
                for (Enum o : ((EnumEncodedValue)encodedValue).getValues()) {
                    possibleValueList.add(o.name());
                }
            } else if (encodedValue instanceof BooleanEncodedValue) {
                possibleValueList.add("true");
                possibleValueList.add("false");
            } else {
                if (!(encodedValue instanceof DecimalEncodedValue) && !(encodedValue instanceof IntEncodedValue)) continue;
                possibleValueList.add(">number");
                possibleValueList.add("<number");
            }
            info.encoded_values.put(name, possibleValueList);
        }
        return info;
    }

    public static class Info {
        public Envelope bbox;
        public final List<ProfileData> profiles = new ArrayList<ProfileData>();
        public String version = Constants.VERSION;
        public boolean elevation;
        public Map<String, List<Object>> encoded_values;
        public String import_date;
        public String data_date;

        public static class ProfileData {
            public String name;

            public ProfileData() {
            }

            public ProfileData(String name) {
                this.name = name;
            }
        }
    }
}

