/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupHelper;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.shapes.BBox;
import io.dropwizard.lifecycle.Managed;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration, ObjectMapper objectMapper) {
        JsonFeatureCollection landmarkSplittingFeatureCollection;
        ObjectMapper localObjectMapper = objectMapper.copy();
        localObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String splitAreaLocation = configuration.getString("prepare.lm.split_area_location", "");
        try (InputStreamReader reader = splitAreaLocation.isEmpty() ? new InputStreamReader(LandmarkStorage.class.getResource("map.geo.json").openStream(), Helper.UTF_CS) : new InputStreamReader((InputStream)new FileInputStream(splitAreaLocation), Helper.UTF_CS);){
            landmarkSplittingFeatureCollection = (JsonFeatureCollection)localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
        }
        catch (IOException e1) {
            this.logger.error("Problem while reading border map GeoJSON. Skipping this.", (Throwable)e1);
            landmarkSplittingFeatureCollection = null;
        }
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopper(landmarkSplittingFeatureCollection);
        if (!configuration.getString("spatial_rules.location", "").isEmpty()) {
            throw new RuntimeException("spatial_rules.location has been deprecated. Please use spatial_rules.borders_directory instead.");
        }
        String spatialRuleBordersDirLocation = configuration.getString("spatial_rules.borders_directory", "");
        if (!spatialRuleBordersDirLocation.isEmpty()) {
            Envelope maxBounds = BBox.toEnvelope((BBox)BBox.parseBBoxString((String)configuration.getString("spatial_rules.max_bbox", "-180, 180, -90, 90")));
            Path bordersDirectory = Paths.get(spatialRuleBordersDirLocation, new String[0]);
            ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
                for (Path borderFile : stream) {
                    BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                        jsonFeatureCollections.add(jsonFeatureCollection);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SpatialRuleLookupHelper.buildAndInjectCountrySpatialRules((GraphHopper)this.graphHopper, (Envelope)maxBounds, jsonFeatureCollections);
        }
        ObjectMapper yamlOM = Jackson.initObjectMapper((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));
        ObjectMapper jsonOM = Jackson.newObjectMapper();
        ArrayList<Object> newProfiles = new ArrayList<Object>();
        for (Profile profile : configuration.getProfiles()) {
            if (!"custom".equals(profile.getWeighting())) {
                newProfiles.add(profile);
                continue;
            }
            Object cm = profile.getHints().getObject("custom_model", null);
            if (cm != null) {
                try {
                    CustomModel customModel = (CustomModel)jsonOM.readValue(jsonOM.writeValueAsBytes(cm), CustomModel.class);
                    newProfiles.add(new CustomProfile(profile).setCustomModel(customModel));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from " + cm + " for profile " + profile.getName(), ex);
                }
            }
            String customModelLocation = profile.getHints().getString("custom_model_file", "");
            if (customModelLocation.isEmpty()) {
                throw new IllegalArgumentException("Missing 'custom_model' or 'custom_model_file' field in profile '" + profile.getName() + "'. To use default specify custom_model_file: empty");
            }
            if ("empty".equals(customModelLocation)) {
                newProfiles.add(new CustomProfile(profile).setCustomModel(new CustomModel()));
                continue;
            }
            try {
                CustomModel customModel = (CustomModel)(customModelLocation.endsWith(".json") ? jsonOM : yamlOM).readValue(new File(customModelLocation), CustomModel.class);
                newProfiles.add(new CustomProfile(profile).setCustomModel(customModel));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load custom_model from location " + customModelLocation + " for profile " + profile.getName(), ex);
            }
        }
        configuration.setProfiles(newProfiles);
        this.graphHopper.init(configuration);
    }

    public void start() {
        this.graphHopper.importOrLoad();
        this.logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {} ints for edge flags, {}", new Object[]{this.graphHopper.getGraphHopperLocation(), this.graphHopper.getOSMFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getEncodingManager().getIntsForFlags(), this.graphHopper.getGraphHopperStorage().toDetailsString()});
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

