/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Constants;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="info")
@Produces(value={"application/json"})
public class InfoResource {
    private final CmdArgs config;
    private final GraphHopperStorage storage;
    private final boolean hasElevation;

    @Inject
    public InfoResource(CmdArgs config, GraphHopperStorage storage, @Named(value="hasElevation") Boolean hasElevation) {
        this.config = config;
        this.storage = storage;
        this.hasElevation = hasElevation;
    }

    @GET
    public Info getInfo() {
        Info info = new Info();
        info.bbox = new BBox(this.storage.getBounds().minLon, this.storage.getBounds().maxLon, this.storage.getBounds().minLat, this.storage.getBounds().maxLat);
        List<String> encoderNames = Arrays.asList(this.storage.getEncodingManager().toString().split(","));
        info.supported_vehicles = new ArrayList<String>(encoderNames);
        if (this.config.has("gtfs.file")) {
            info.supported_vehicles.add("pt");
        }
        for (String encoderName : encoderNames) {
            Info.PerVehicle perVehicleJson = new Info.PerVehicle();
            perVehicleJson.elevation = this.hasElevation;
            perVehicleJson.turn_costs = this.storage.getEncodingManager().getEncoder(encoderName).supports(TurnWeighting.class);
            info.features.put(encoderName, perVehicleJson);
        }
        if (this.config.has("gtfs.file")) {
            info.features.put("pt", new Info.PerVehicle());
        }
        info.import_date = this.storage.getProperties().get("datareader.import.date");
        info.data_date = this.storage.getProperties().get("datareader.data.date");
        info.prepare_ch_date = this.storage.getProperties().get("prepare.ch.date");
        info.prepare_date = this.storage.getProperties().get("prepare.ch.date");
        return info;
    }

    public static class Info {
        public BBox bbox;
        public List<String> supported_vehicles;
        public final Map<String, PerVehicle> features = new HashMap<String, PerVehicle>();
        public String version = Constants.VERSION;
        public String build_date = Constants.BUILD_DATE;
        public String import_date;
        public String data_date;
        public String prepare_ch_date;
        public String prepare_date;

        public static class PerVehicle {
            public boolean elevation;
            public boolean turn_costs;
        }
    }
}

