/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm;

import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyModuleListener;
import com.graphhopper.jsprit.core.algorithm.selector.SolutionSelector;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchStrategy {
    private static Logger logger = LoggerFactory.getLogger(SearchStrategy.class);
    private final Collection<SearchStrategyModule> searchStrategyModules = new ArrayList<SearchStrategyModule>();
    private final SolutionSelector solutionSelector;
    private final SolutionCostCalculator solutionCostCalculator;
    private final SolutionAcceptor solutionAcceptor;
    private final String id;
    private String name;

    public SearchStrategy(String id, SolutionSelector solutionSelector, SolutionAcceptor solutionAcceptor, SolutionCostCalculator solutionCostCalculator) {
        if (id == null) {
            throw new IllegalStateException("strategy id cannot be null");
        }
        this.solutionSelector = solutionSelector;
        this.solutionAcceptor = solutionAcceptor;
        this.solutionCostCalculator = solutionCostCalculator;
        this.id = id;
        logger.debug("initialise {}", (Object)this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<SearchStrategyModule> getSearchStrategyModules() {
        return Collections.unmodifiableCollection(this.searchStrategyModules);
    }

    public SolutionSelector getSolutionSelector() {
        return this.solutionSelector;
    }

    public SolutionAcceptor getSolutionAcceptor() {
        return this.solutionAcceptor;
    }

    public String toString() {
        return "searchStrategy [#modules=" + this.searchStrategyModules.size() + "][selector=" + this.solutionSelector + "][acceptor=" + this.solutionAcceptor + "]";
    }

    public DiscoveredSolution run(VehicleRoutingProblem vrp, Collection<VehicleRoutingProblemSolution> solutions) {
        VehicleRoutingProblemSolution solution = this.solutionSelector.selectSolution(solutions);
        if (solution == null) {
            throw new IllegalStateException(this.getErrMsg());
        }
        VehicleRoutingProblemSolution lastSolution = VehicleRoutingProblemSolution.copyOf(solution);
        for (SearchStrategyModule module : this.searchStrategyModules) {
            lastSolution = module.runAndGetSolution(lastSolution);
        }
        double costs = this.solutionCostCalculator.getCosts(lastSolution);
        lastSolution.setCost(costs);
        boolean solutionAccepted = this.solutionAcceptor.acceptSolution(solutions, lastSolution);
        return new DiscoveredSolution(lastSolution, solutionAccepted, this.getId());
    }

    private String getErrMsg() {
        return "solution is null. check solutionSelector to return an appropriate solution. \nfigure out whether you start with an initial solution. either you set it manually by algorithm.addInitialSolution(...) or let the algorithm create an initial solution for you. then add the <construction>...</construction> xml-snippet to your algorithm's config file.";
    }

    public void addModule(SearchStrategyModule module) {
        if (module == null) {
            throw new IllegalStateException("module to be added is null.");
        }
        this.searchStrategyModules.add(module);
        logger.debug("module added [module={}][#modules={}]", (Object)module, (Object)this.searchStrategyModules.size());
    }

    public void addModuleListener(SearchStrategyModuleListener moduleListener) {
        for (SearchStrategyModule module : this.searchStrategyModules) {
            module.addModuleListener(moduleListener);
        }
    }

    public static class DiscoveredSolution {
        private VehicleRoutingProblemSolution solution;
        private boolean accepted;
        private String strategyId;

        public DiscoveredSolution(VehicleRoutingProblemSolution solution, boolean accepted, String strategyId) {
            this.solution = solution;
            this.accepted = accepted;
            this.strategyId = strategyId;
        }

        public VehicleRoutingProblemSolution getSolution() {
            return this.solution;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public String getStrategyId() {
            return this.strategyId;
        }

        public String toString() {
            return "[strategyId=" + this.strategyId + "][solution=" + this.solution + "][accepted=" + this.accepted + "]";
        }
    }
}

