/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.acceptor;

import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;

public class GreedyAcceptance
implements SolutionAcceptor {
    private final int solutionMemory;

    public GreedyAcceptance(int solutionMemory) {
        this.solutionMemory = solutionMemory;
    }

    @Override
    public boolean acceptSolution(Collection<VehicleRoutingProblemSolution> solutions, VehicleRoutingProblemSolution newSolution) {
        boolean solutionAccepted = false;
        if (solutions.size() < this.solutionMemory) {
            solutions.add(newSolution);
            solutionAccepted = true;
        } else {
            VehicleRoutingProblemSolution worstSolution = null;
            for (VehicleRoutingProblemSolution s : solutions) {
                if (worstSolution == null) {
                    worstSolution = s;
                    continue;
                }
                if (!(s.getCost() > worstSolution.getCost())) continue;
                worstSolution = s;
            }
            if (newSolution.getCost() < worstSolution.getCost()) {
                solutions.remove(worstSolution);
                solutions.add(newSolution);
                solutionAccepted = true;
            }
        }
        return solutionAccepted;
    }

    public String toString() {
        return "[name=GreedyAcceptance]";
    }
}

