/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.box;

import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.Collection;
import java.util.Random;

class ConcurrentInsertionNoiseMaker
implements SoftActivityConstraint,
IterationStartsListener {
    private final double noiseProbability;
    private boolean makeNoise = false;
    private double noiseLevel = 0.1;
    private Random random = RandomNumberGeneration.newInstance();
    private Random[] randomArray;
    private double maxCosts;

    ConcurrentInsertionNoiseMaker(VehicleRoutingProblem vrp, double maxCosts, double noiseLevel, double noiseProbability) {
        this.noiseLevel = noiseLevel;
        this.noiseProbability = noiseProbability;
        this.maxCosts = maxCosts;
        this.randomArray = new Random[vrp.getNuActivities() + 2];
        for (int i = 0; i < this.randomArray.length; ++i) {
            Random r = new Random();
            r.setSeed(this.random.nextLong());
            this.randomArray[i] = r;
        }
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.makeNoise = this.random.nextDouble() < this.noiseProbability;
    }

    @Override
    public double getCosts(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        if (this.makeNoise) {
            return this.noiseLevel * this.maxCosts * this.randomArray[newAct.getIndex()].nextDouble();
        }
        return 0.0;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

