/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.box;

import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.Collection;
import java.util.Random;

class InsertionNoiseMaker
implements SoftActivityConstraint,
IterationStartsListener {
    private final double noiseProbability;
    private boolean makeNoise = false;
    private double noiseLevel = 0.1;
    private Random random = RandomNumberGeneration.newInstance();
    private double maxCosts;

    InsertionNoiseMaker(VehicleRoutingProblem vrp, double maxCosts, double noiseLevel, double noiseProbability) {
        this.noiseLevel = noiseLevel;
        this.noiseProbability = noiseProbability;
        this.maxCosts = maxCosts;
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.makeNoise = this.random.nextDouble() < this.noiseProbability;
    }

    @Override
    public double getCosts(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        if (this.makeNoise) {
            return this.noiseLevel * this.maxCosts * this.random.nextDouble();
        }
        return 0.0;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

