/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.listener;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.StrategySelectedListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public class VehicleRoutingAlgorithmListeners {
    private TreeSet<PrioritizedVRAListener> algorithmListeners = new TreeSet<PrioritizedVRAListener>(new Comparator<PrioritizedVRAListener>(){

        @Override
        public int compare(PrioritizedVRAListener o1, PrioritizedVRAListener o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getPriority() == Priority.HIGH && o2.getPriority() != Priority.HIGH) {
                return -1;
            }
            if (o2.getPriority() == Priority.HIGH && o1.getPriority() != Priority.HIGH) {
                return 1;
            }
            if (o1.getPriority() == Priority.MEDIUM && o2.getPriority() != Priority.MEDIUM) {
                return -1;
            }
            if (o2.getPriority() == Priority.MEDIUM && o1.getPriority() != Priority.MEDIUM) {
                return 1;
            }
            return 1;
        }
    });

    public Collection<VehicleRoutingAlgorithmListener> getAlgorithmListeners() {
        ArrayList<VehicleRoutingAlgorithmListener> list = new ArrayList<VehicleRoutingAlgorithmListener>();
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            list.add(l.getListener());
        }
        return Collections.unmodifiableCollection(list);
    }

    public void remove(PrioritizedVRAListener listener) {
        boolean removed = this.algorithmListeners.remove(listener);
        if (!removed) {
            throw new IllegalStateException("cannot remove listener");
        }
    }

    public void addListener(VehicleRoutingAlgorithmListener listener, Priority priority) {
        this.algorithmListeners.add(new PrioritizedVRAListener(priority, listener));
    }

    public void addListener(VehicleRoutingAlgorithmListener listener) {
        this.addListener(listener, Priority.LOW);
    }

    public void algorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            if (!(l.getListener() instanceof AlgorithmEndsListener)) continue;
            ((AlgorithmEndsListener)l.getListener()).informAlgorithmEnds(problem, solutions);
        }
    }

    public void iterationEnds(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            if (!(l.getListener() instanceof IterationEndsListener)) continue;
            ((IterationEndsListener)l.getListener()).informIterationEnds(i, problem, solutions);
        }
    }

    public void iterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            if (!(l.getListener() instanceof IterationStartsListener)) continue;
            ((IterationStartsListener)l.getListener()).informIterationStarts(i, problem, solutions);
        }
    }

    public void algorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            if (!(l.getListener() instanceof AlgorithmStartsListener)) continue;
            ((AlgorithmStartsListener)l.getListener()).informAlgorithmStarts(problem, algorithm, solutions);
        }
    }

    public void add(PrioritizedVRAListener l) {
        this.algorithmListeners.add(l);
    }

    public void addAll(Collection<PrioritizedVRAListener> algorithmListeners) {
        for (PrioritizedVRAListener l : algorithmListeners) {
            this.algorithmListeners.add(l);
        }
    }

    public void selectedStrategy(SearchStrategy.DiscoveredSolution discoveredSolution, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        for (PrioritizedVRAListener l : this.algorithmListeners) {
            if (!(l.getListener() instanceof StrategySelectedListener)) continue;
            ((StrategySelectedListener)l.getListener()).informSelectedStrategy(discoveredSolution, problem, solutions);
        }
    }

    public static enum Priority {
        HIGH,
        MEDIUM,
        LOW;

    }

    public static class PrioritizedVRAListener {
        Priority priority;
        VehicleRoutingAlgorithmListener l;

        public PrioritizedVRAListener(Priority priority, VehicleRoutingAlgorithmListener l) {
            this.priority = priority;
            this.l = l;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public VehicleRoutingAlgorithmListener getListener() {
            return this.l;
        }
    }
}

