/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;

class AdditionalAccessEgressCalculator {
    private VehicleRoutingTransportCosts routingCosts;

    public AdditionalAccessEgressCalculator(VehicleRoutingTransportCosts routingCosts) {
        this.routingCosts = routingCosts;
    }

    public double getCosts(JobInsertionContext insertionContext) {
        double delta_access = 0.0;
        double delta_egress = 0.0;
        VehicleRoute currentRoute = insertionContext.getRoute();
        Vehicle newVehicle = insertionContext.getNewVehicle();
        Driver newDriver = insertionContext.getNewDriver();
        double newVehicleDepartureTime = insertionContext.getNewDepTime();
        if (!currentRoute.isEmpty()) {
            double accessTransportCostNew = this.routingCosts.getTransportCost(newVehicle.getStartLocation(), currentRoute.getActivities().get(0).getLocation(), newVehicleDepartureTime, newDriver, newVehicle);
            double accessTransportCostOld = this.routingCosts.getTransportCost(currentRoute.getStart().getLocation(), currentRoute.getActivities().get(0).getLocation(), currentRoute.getDepartureTime(), currentRoute.getDriver(), currentRoute.getVehicle());
            delta_access = accessTransportCostNew - accessTransportCostOld;
            if (newVehicle.isReturnToDepot()) {
                TourActivity lastActivityBeforeEndOfRoute = currentRoute.getActivities().get(currentRoute.getActivities().size() - 1);
                double lastActivityEndTimeWithOldVehicleAndDepartureTime = lastActivityBeforeEndOfRoute.getEndTime();
                double lastActivityEndTimeEstimationWithNewVehicleAndNewDepartureTime = Math.max(0.0, lastActivityEndTimeWithOldVehicleAndDepartureTime + (newVehicleDepartureTime - currentRoute.getDepartureTime()));
                double egressTransportCostNew = this.routingCosts.getTransportCost(lastActivityBeforeEndOfRoute.getLocation(), newVehicle.getEndLocation(), lastActivityEndTimeEstimationWithNewVehicleAndNewDepartureTime, newDriver, newVehicle);
                double egressTransportCostOld = this.routingCosts.getTransportCost(lastActivityBeforeEndOfRoute.getLocation(), currentRoute.getEnd().getLocation(), lastActivityEndTimeWithOldVehicleAndDepartureTime, currentRoute.getDriver(), currentRoute.getVehicle());
                delta_egress = egressTransportCostNew - egressTransportCostOld;
            }
        }
        return delta_access + delta_egress;
    }
}

