/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.AdditionalAccessEgressCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertBreak;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.SwitchVehicle;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.BreakActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BreakInsertionCalculator
implements JobInsertionCostsCalculator {
    private static final Logger logger = LoggerFactory.getLogger(BreakInsertionCalculator.class);
    private HardRouteConstraint hardRouteLevelConstraint;
    private HardActivityConstraint hardActivityLevelConstraint;
    private SoftRouteConstraint softRouteConstraint;
    private SoftActivityConstraint softActivityConstraint;
    private VehicleRoutingTransportCosts transportCosts;
    private final VehicleRoutingActivityCosts activityCosts;
    private ActivityInsertionCostsCalculator additionalTransportCostsCalculator;
    private JobActivityFactory activityFactory;
    private AdditionalAccessEgressCalculator additionalAccessEgressCalculator;

    public BreakInsertionCalculator(VehicleRoutingTransportCosts routingCosts, VehicleRoutingActivityCosts activityCosts, ActivityInsertionCostsCalculator additionalTransportCostsCalculator, ConstraintManager constraintManager) {
        this.transportCosts = routingCosts;
        this.activityCosts = activityCosts;
        this.hardRouteLevelConstraint = constraintManager;
        this.hardActivityLevelConstraint = constraintManager;
        this.softActivityConstraint = constraintManager;
        this.softRouteConstraint = constraintManager;
        this.additionalTransportCostsCalculator = additionalTransportCostsCalculator;
        this.additionalAccessEgressCalculator = new AdditionalAccessEgressCalculator(routingCosts);
        logger.debug("initialise " + this);
    }

    public void setJobActivityFactory(JobActivityFactory jobActivityFactory) {
        this.activityFactory = jobActivityFactory;
    }

    public String toString() {
        return "[name=calculatesServiceInsertion]";
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle, double newVehicleDepartureTime, Driver newDriver, double bestKnownCosts) {
        Break breakToInsert = (Break)jobToInsert;
        if (newVehicle.getBreak() == null || newVehicle.getBreak() != breakToInsert) {
            return InsertionData.createEmptyInsertionData();
        }
        if (currentRoute.isEmpty()) {
            return InsertionData.createEmptyInsertionData();
        }
        JobInsertionContext insertionContext = new JobInsertionContext(currentRoute, jobToInsert, newVehicle, newDriver, newVehicleDepartureTime);
        int insertionIndex = InsertionData.NO_INDEX;
        BreakActivity breakAct2Insert = (BreakActivity)this.activityFactory.createActivities(breakToInsert).get(0);
        insertionContext.getAssociatedActivities().add(breakAct2Insert);
        if (!this.hardRouteLevelConstraint.fulfilled(insertionContext)) {
            return InsertionData.createEmptyInsertionData();
        }
        double additionalICostsAtRouteLevel = this.softRouteConstraint.getCosts(insertionContext);
        double bestCost = bestKnownCosts;
        additionalICostsAtRouteLevel += this.additionalAccessEgressCalculator.getCosts(insertionContext);
        Start start = new Start(newVehicle.getStartLocation(), newVehicle.getEarliestDeparture(), Double.MAX_VALUE);
        start.setEndTime(newVehicleDepartureTime);
        End end = new End(newVehicle.getEndLocation(), 0.0, newVehicle.getLatestArrival());
        Location bestLocation = null;
        TourActivity prevAct = start;
        double prevActStartTime = newVehicleDepartureTime;
        int actIndex = 0;
        Iterator<TourActivity> activityIterator = currentRoute.getActivities().iterator();
        boolean tourEnd = false;
        while (!tourEnd) {
            TourActivity nextAct;
            if (activityIterator.hasNext()) {
                nextAct = activityIterator.next();
            } else {
                nextAct = end;
                tourEnd = true;
            }
            boolean breakThis = true;
            List<Location> locations = Arrays.asList(prevAct.getLocation(), nextAct.getLocation());
            for (Location location : locations) {
                breakAct2Insert.setLocation(location);
                breakAct2Insert.setTheoreticalEarliestOperationStartTime(breakToInsert.getTimeWindow().getStart());
                breakAct2Insert.setTheoreticalLatestOperationStartTime(breakToInsert.getTimeWindow().getEnd());
                HardActivityConstraint.ConstraintsStatus status = this.hardActivityLevelConstraint.fulfilled(insertionContext, prevAct, breakAct2Insert, nextAct, prevActStartTime);
                if (status.equals((Object)HardActivityConstraint.ConstraintsStatus.FULFILLED)) {
                    double additionalTransportationCosts;
                    double additionalICostsAtActLevel = this.softActivityConstraint.getCosts(insertionContext, prevAct, breakAct2Insert, nextAct, prevActStartTime);
                    if (additionalICostsAtRouteLevel + additionalICostsAtActLevel + (additionalTransportationCosts = this.additionalTransportCostsCalculator.getCosts(insertionContext, prevAct, nextAct, breakAct2Insert, prevActStartTime)) < bestCost) {
                        bestCost = additionalICostsAtRouteLevel + additionalICostsAtActLevel + additionalTransportationCosts;
                        insertionIndex = actIndex;
                        bestLocation = location;
                    }
                    breakThis = false;
                    continue;
                }
                if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
                breakThis = false;
            }
            double nextActArrTime = prevActStartTime + this.transportCosts.getTransportTime(prevAct.getLocation(), nextAct.getLocation(), prevActStartTime, newDriver, newVehicle);
            prevActStartTime = Math.max(nextActArrTime, nextAct.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(nextAct, nextActArrTime, newDriver, newVehicle);
            prevAct = nextAct;
            ++actIndex;
            if (!breakThis) continue;
            break;
        }
        if (insertionIndex == InsertionData.NO_INDEX) {
            return InsertionData.createEmptyInsertionData();
        }
        InsertionData insertionData = new InsertionData(bestCost, InsertionData.NO_INDEX, insertionIndex, newVehicle, newDriver);
        breakAct2Insert.setLocation(bestLocation);
        insertionData.getEvents().add(new InsertBreak(currentRoute, newVehicle, breakAct2Insert, insertionIndex));
        insertionData.getEvents().add(new SwitchVehicle(currentRoute, newVehicle, newVehicleDepartureTime));
        insertionData.setVehicleDepartureTime(newVehicleDepartureTime);
        return insertionData;
    }
}

