/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.BreakInsertionCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.Event;
import com.graphhopper.jsprit.core.algorithm.recreate.EventListeners;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.LocalActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakScheduling
implements InsertionStartsListener,
JobInsertedListener,
RuinListener {
    private static final Logger logger = LoggerFactory.getLogger(BreakScheduling.class);
    private final StateManager stateManager;
    private final BreakInsertionCalculator breakInsertionCalculator;
    private final EventListeners eventListeners;
    private Set<VehicleRoute> modifiedRoutes = new HashSet<VehicleRoute>();

    public BreakScheduling(VehicleRoutingProblem vrp, StateManager stateManager, ConstraintManager constraintManager) {
        this.stateManager = stateManager;
        this.breakInsertionCalculator = new BreakInsertionCalculator(vrp.getTransportCosts(), vrp.getActivityCosts(), new LocalActivityInsertionCostsCalculator(vrp.getTransportCosts(), vrp.getActivityCosts(), stateManager), constraintManager);
        this.breakInsertionCalculator.setJobActivityFactory(vrp.getJobActivityFactory());
        this.eventListeners = new EventListeners();
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        Break aBreak = inRoute.getVehicle().getBreak();
        if (aBreak != null) {
            InsertionData iData;
            boolean removed = inRoute.getTourActivities().removeJob(aBreak);
            if (removed) {
                logger.trace("ruin: {}", (Object)aBreak.getId());
                this.stateManager.removed(aBreak, inRoute);
                this.stateManager.reCalculateStates(inRoute);
            }
            if (inRoute.getEnd().getArrTime() > aBreak.getTimeWindow().getEnd() && !((iData = this.breakInsertionCalculator.getInsertionData(inRoute, aBreak, inRoute.getVehicle(), inRoute.getDepartureTime(), inRoute.getDriver(), Double.MAX_VALUE)) instanceof InsertionData.NoInsertionFound)) {
                logger.trace("insert: [jobId={}]{}", (Object)aBreak.getId(), (Object)iData);
                for (Event e : iData.getEvents()) {
                    this.eventListeners.inform(e);
                }
                this.stateManager.informJobInserted(aBreak, inRoute, 0.0, 0.0);
            }
        }
    }

    @Override
    public void ruinStarts(Collection<VehicleRoute> routes) {
    }

    @Override
    public void ruinEnds(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        for (VehicleRoute route : routes) {
            Break aBreak = route.getVehicle().getBreak();
            boolean removed = route.getTourActivities().removeJob(aBreak);
            if (!removed) continue;
            logger.trace("ruin: {}", (Object)aBreak.getId());
        }
        ArrayList<Break> breaks = new ArrayList<Break>();
        for (Job j : unassignedJobs) {
            if (!(j instanceof Break)) continue;
            breaks.add((Break)j);
        }
        for (Break b : breaks) {
            unassignedJobs.remove(b);
        }
    }

    @Override
    public void removed(Job job, VehicleRoute fromRoute) {
        if (fromRoute.getVehicle().getBreak() != null) {
            this.modifiedRoutes.add(fromRoute);
        }
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        for (VehicleRoute route : vehicleRoutes) {
            InsertionData iData;
            Break aBreak = route.getVehicle().getBreak();
            if (aBreak == null || route.getTourActivities().servesJob(aBreak) || !(route.getEnd().getArrTime() > aBreak.getTimeWindow().getEnd()) || (iData = this.breakInsertionCalculator.getInsertionData(route, aBreak, route.getVehicle(), route.getDepartureTime(), route.getDriver(), Double.MAX_VALUE)) instanceof InsertionData.NoInsertionFound) continue;
            logger.trace("insert: [jobId={}]{}", (Object)aBreak.getId(), (Object)iData);
            for (Event e : iData.getEvents()) {
                this.eventListeners.inform(e);
            }
            this.stateManager.informJobInserted(aBreak, route, 0.0, 0.0);
        }
    }
}

