/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionConsideringFixCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.Collection;

final class ConfigureFixCostCalculator
implements InsertionStartsListener,
JobInsertedListener {
    VehicleRoutingProblem vrp;
    JobInsertionConsideringFixCostsCalculator calcConsideringFix;
    private int nuOfJobsToRecreate;

    public ConfigureFixCostCalculator(VehicleRoutingProblem vrp, JobInsertionConsideringFixCostsCalculator calcConsideringFix) {
        this.vrp = vrp;
        this.calcConsideringFix = calcConsideringFix;
    }

    public String toString() {
        return "[name=configureFixCostCalculator]";
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        this.nuOfJobsToRecreate = unassignedJobs.size();
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.vrp.getJobs().values().size();
        this.calcConsideringFix.setSolutionCompletenessRatio(completenessRatio);
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        --this.nuOfJobsToRecreate;
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.vrp.getJobs().values().size();
        this.calcConsideringFix.setSolutionCompletenessRatio(completenessRatio);
    }
}

