/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;

public class DefaultScorer
implements ScoringFunction {
    private VehicleRoutingProblem vrp;
    private double timeWindowParam = -0.5;
    private double depotDistanceParam = 0.1;
    private double minTimeWindowScore = -100000.0;

    public DefaultScorer(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
    }

    public void setTimeWindowParam(double tw_param) {
        this.timeWindowParam = tw_param;
    }

    public void setDepotDistanceParam(double depotDistance_param) {
        this.depotDistanceParam = depotDistance_param;
    }

    @Override
    public double score(InsertionData best, Job job) {
        double score;
        if (job instanceof Service) {
            score = this.scoreService(best, job);
        } else if (job instanceof Shipment) {
            score = this.scoreShipment(best, job);
        } else {
            throw new IllegalStateException("not supported");
        }
        return score;
    }

    private double scoreShipment(InsertionData best, Job job) {
        Shipment shipment = (Shipment)job;
        double maxDepotDistance_1 = Math.max(this.getDistance(best.getSelectedVehicle().getStartLocation(), shipment.getPickupLocation()), this.getDistance(best.getSelectedVehicle().getStartLocation(), shipment.getDeliveryLocation()));
        double maxDepotDistance_2 = Math.max(this.getDistance(best.getSelectedVehicle().getEndLocation(), shipment.getPickupLocation()), this.getDistance(best.getSelectedVehicle().getEndLocation(), shipment.getDeliveryLocation()));
        double maxDepotDistance = Math.max(maxDepotDistance_1, maxDepotDistance_2);
        double minTimeToOperate = Math.min(shipment.getPickupTimeWindow().getEnd() - shipment.getPickupTimeWindow().getStart(), shipment.getDeliveryTimeWindow().getEnd() - shipment.getDeliveryTimeWindow().getStart());
        return Math.max(this.timeWindowParam * minTimeToOperate, this.minTimeWindowScore) + this.depotDistanceParam * maxDepotDistance;
    }

    private double scoreService(InsertionData best, Job job) {
        Location location = ((Service)job).getLocation();
        double maxDepotDistance = 0.0;
        if (location != null) {
            maxDepotDistance = Math.max(this.getDistance(best.getSelectedVehicle().getStartLocation(), location), this.getDistance(best.getSelectedVehicle().getEndLocation(), location));
        }
        return Math.max(this.timeWindowParam * (((Service)job).getTimeWindow().getEnd() - ((Service)job).getTimeWindow().getStart()), this.minTimeWindowScore) + this.depotDistanceParam * maxDepotDistance;
    }

    private double getDistance(Location loc1, Location loc2) {
        return this.vrp.getTransportCosts().getTransportCost(loc1, loc2, 0.0, null, null);
    }

    public String toString() {
        return "[name=defaultScorer][twParam=" + this.timeWindowParam + "][depotDistanceParam=" + this.depotDistanceParam + "]";
    }
}

