/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionConsideringFixCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import java.util.Collection;

public class DellAmicoFixCostCalculator
implements SoftRouteConstraint,
InsertionStartsListener,
JobInsertedListener {
    private int nuOfJobsToRecreate;
    private final JobInsertionConsideringFixCostsCalculator calculator;
    private final int nuOfJobs;

    public DellAmicoFixCostCalculator(int nuOfJobs, RouteAndActivityStateGetter stateGetter) {
        this.nuOfJobs = nuOfJobs;
        this.calculator = new JobInsertionConsideringFixCostsCalculator(null, stateGetter);
    }

    @Override
    public double getCosts(JobInsertionContext insertionContext) {
        return this.calculator.getCosts(insertionContext);
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        this.nuOfJobsToRecreate = unassignedJobs.size();
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.nuOfJobs;
        this.calculator.setSolutionCompletenessRatio(completenessRatio);
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        --this.nuOfJobsToRecreate;
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.nuOfJobs;
        this.calculator.setSolutionCompletenessRatio(completenessRatio);
        System.out.println(completenessRatio);
    }
}

