/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListeners;
import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultShipmentActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DefaultTourActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivityFactory;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourShipmentActivityFactory;
import java.util.List;

class Inserter {
    private InsertionListeners insertionListeners;
    private JobInsertionHandler jobInsertionHandler;
    private VehicleRoutingProblem vehicleRoutingProblem;

    public Inserter(InsertionListeners insertionListeners, VehicleRoutingProblem vehicleRoutingProblem) {
        this.insertionListeners = insertionListeners;
        new DefaultTourActivityFactory();
        this.jobInsertionHandler = new ServiceInsertionHandler(vehicleRoutingProblem);
        this.jobInsertionHandler.setNextHandler(new ShipmentInsertionHandler(vehicleRoutingProblem));
    }

    public void insertJob(Job job, InsertionData insertionData, VehicleRoute vehicleRoute) {
        this.insertionListeners.informBeforeJobInsertion(job, insertionData, vehicleRoute);
        if (insertionData == null || insertionData instanceof InsertionData.NoInsertionFound) {
            throw new IllegalStateException("insertionData null. cannot insert job.");
        }
        if (job == null) {
            throw new IllegalStateException("cannot insert null-job");
        }
        if (!vehicleRoute.getVehicle().getId().equals(insertionData.getSelectedVehicle().getId())) {
            this.insertionListeners.informVehicleSwitched(vehicleRoute, vehicleRoute.getVehicle(), insertionData.getSelectedVehicle());
            vehicleRoute.setVehicleAndDepartureTime(insertionData.getSelectedVehicle(), insertionData.getVehicleDepartureTime());
        }
        this.jobInsertionHandler.handleJobInsertion(job, insertionData, vehicleRoute);
        this.insertionListeners.informJobInserted(job, vehicleRoute, insertionData.getInsertionCost(), insertionData.getAdditionalTime());
    }

    class ShipmentInsertionHandler
    implements JobInsertionHandler {
        private final VehicleRoutingProblem vehicleRoutingProblem;
        private TourShipmentActivityFactory activityFactory = new DefaultShipmentActivityFactory();
        private JobInsertionHandler delegator = new JobExceptionHandler();

        public ShipmentInsertionHandler(VehicleRoutingProblem vehicleRoutingProblem) {
            this.vehicleRoutingProblem = vehicleRoutingProblem;
        }

        @Override
        public void handleJobInsertion(Job job, InsertionData iData, VehicleRoute route) {
            if (job instanceof Shipment) {
                List<AbstractActivity> acts = this.vehicleRoutingProblem.copyAndGetActivities(job);
                TourActivity pickupShipment = acts.get(0);
                TourActivity deliverShipment = acts.get(1);
                route.setVehicleAndDepartureTime(iData.getSelectedVehicle(), iData.getVehicleDepartureTime());
                if (!iData.getSelectedVehicle().isReturnToDepot() && iData.getDeliveryInsertionIndex() >= route.getActivities().size()) {
                    this.setEndLocation(route, (Shipment)job);
                }
                route.getTourActivities().addActivity(iData.getDeliveryInsertionIndex(), deliverShipment);
                route.getTourActivities().addActivity(iData.getPickupInsertionIndex(), pickupShipment);
            } else {
                this.delegator.handleJobInsertion(job, iData, route);
            }
        }

        private void setEndLocation(VehicleRoute route, Shipment shipment) {
            route.getEnd().setLocation(shipment.getDeliveryLocation());
        }

        @Override
        public void setNextHandler(JobInsertionHandler jobInsertionHandler) {
            this.delegator = jobInsertionHandler;
        }
    }

    class ServiceInsertionHandler
    implements JobInsertionHandler {
        private TourActivityFactory activityFactory = new DefaultTourActivityFactory();
        private JobInsertionHandler delegator = new JobExceptionHandler();
        private VehicleRoutingProblem vehicleRoutingProblem;

        public ServiceInsertionHandler(VehicleRoutingProblem vehicleRoutingProblem) {
            this.vehicleRoutingProblem = vehicleRoutingProblem;
        }

        @Override
        public void handleJobInsertion(Job job, InsertionData iData, VehicleRoute route) {
            if (job instanceof Service) {
                route.setVehicleAndDepartureTime(iData.getSelectedVehicle(), iData.getVehicleDepartureTime());
                if (!iData.getSelectedVehicle().isReturnToDepot() && iData.getDeliveryInsertionIndex() >= route.getTourActivities().getActivities().size()) {
                    this.setEndLocation(route, (Service)job);
                }
                TourActivity activity = this.vehicleRoutingProblem.copyAndGetActivities(job).get(0);
                route.getTourActivities().addActivity(iData.getDeliveryInsertionIndex(), activity);
            } else {
                this.delegator.handleJobInsertion(job, iData, route);
            }
        }

        private void setEndLocation(VehicleRoute route, Service service) {
            route.getEnd().setLocation(service.getLocation());
        }

        @Override
        public void setNextHandler(JobInsertionHandler jobInsertionHandler) {
            this.delegator = jobInsertionHandler;
        }
    }

    class JobExceptionHandler
    implements JobInsertionHandler {
        JobExceptionHandler() {
        }

        @Override
        public void handleJobInsertion(Job job, InsertionData iData, VehicleRoute route) {
            throw new IllegalStateException("job insertion is not supported. Do not know job type.");
        }

        @Override
        public void setNextHandler(JobInsertionHandler handler) {
        }
    }

    static interface JobInsertionHandler {
        public void handleJobInsertion(Job var1, InsertionData var2, VehicleRoute var3);

        public void setNextHandler(JobInsertionHandler var1);
    }
}

