/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JobInsertionConsideringFixCostsCalculator
implements JobInsertionCostsCalculator,
SoftRouteConstraint {
    private static final Logger logger = LoggerFactory.getLogger(JobInsertionConsideringFixCostsCalculator.class);
    private final JobInsertionCostsCalculator standardServiceInsertion;
    private double weight_deltaFixCost = 0.5;
    private double solution_completeness_ratio = 0.5;
    private RouteAndActivityStateGetter stateGetter;

    public JobInsertionConsideringFixCostsCalculator(JobInsertionCostsCalculator standardInsertionCalculator, RouteAndActivityStateGetter stateGetter) {
        this.standardServiceInsertion = standardInsertionCalculator;
        this.stateGetter = stateGetter;
        logger.debug("inialise {}", (Object)this);
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle, double newVehicleDepartureTime, Driver newDriver, double bestKnownPrice) {
        double fixcost_contribution = this.getFixCostContribution(currentRoute, jobToInsert, newVehicle);
        if (fixcost_contribution > bestKnownPrice) {
            return InsertionData.createEmptyInsertionData();
        }
        InsertionData iData = this.standardServiceInsertion.getInsertionData(currentRoute, jobToInsert, newVehicle, newVehicleDepartureTime, newDriver, bestKnownPrice);
        if (iData instanceof InsertionData.NoInsertionFound) {
            return iData;
        }
        double totalInsertionCost = iData.getInsertionCost() + fixcost_contribution;
        InsertionData insertionData = new InsertionData(totalInsertionCost, iData.getPickupInsertionIndex(), iData.getDeliveryInsertionIndex(), newVehicle, newDriver);
        insertionData.setVehicleDepartureTime(newVehicleDepartureTime);
        insertionData.getEvents().addAll(iData.getEvents());
        return insertionData;
    }

    private double getFixCostContribution(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle) {
        Capacity currentMaxLoadInRoute = this.getCurrentMaxLoadInRoute(currentRoute);
        double relFixCost = this.getDeltaRelativeFixCost(currentRoute, newVehicle, jobToInsert, currentMaxLoadInRoute);
        double absFixCost = this.getDeltaAbsoluteFixCost(currentRoute, newVehicle, jobToInsert, currentMaxLoadInRoute);
        double deltaFixCost = (1.0 - this.solution_completeness_ratio) * relFixCost + this.solution_completeness_ratio * absFixCost;
        double fixcost_contribution = this.weight_deltaFixCost * this.solution_completeness_ratio * deltaFixCost;
        return fixcost_contribution;
    }

    public void setWeightOfFixCost(double weight) {
        this.weight_deltaFixCost = weight;
        logger.debug("set weightOfFixCostSaving to {}", (Object)weight);
    }

    public String toString() {
        return "[name=calculatesServiceInsertionConsideringFixCost][weightOfFixedCostSavings=" + this.weight_deltaFixCost + "]";
    }

    public void setSolutionCompletenessRatio(double ratio) {
        this.solution_completeness_ratio = ratio;
    }

    private double getDeltaAbsoluteFixCost(VehicleRoute route, Vehicle newVehicle, Job job, Capacity currentMaxLoadInRoute) {
        Capacity load = Capacity.addup(currentMaxLoadInRoute, job.getSize());
        double currentFix = 0.0;
        if (route.getVehicle() != null && !(route.getVehicle() instanceof VehicleImpl.NoVehicle)) {
            currentFix += route.getVehicle().getType().getVehicleCostParams().fix;
        }
        if (!newVehicle.getType().getCapacityDimensions().isGreaterOrEqual(load)) {
            return Double.MAX_VALUE;
        }
        return newVehicle.getType().getVehicleCostParams().fix - currentFix;
    }

    private double getDeltaRelativeFixCost(VehicleRoute route, Vehicle newVehicle, Job job, Capacity currentLoad) {
        Capacity load = Capacity.addup(currentLoad, job.getSize());
        double currentRelFix = 0.0;
        if (route.getVehicle() != null && !(route.getVehicle() instanceof VehicleImpl.NoVehicle)) {
            currentRelFix += route.getVehicle().getType().getVehicleCostParams().fix * Capacity.divide(currentLoad, route.getVehicle().getType().getCapacityDimensions());
        }
        if (!newVehicle.getType().getCapacityDimensions().isGreaterOrEqual(load)) {
            return Double.MAX_VALUE;
        }
        double relativeFixCost = newVehicle.getType().getVehicleCostParams().fix * Capacity.divide(load, newVehicle.getType().getCapacityDimensions()) - currentRelFix;
        return relativeFixCost;
    }

    private Capacity getCurrentMaxLoadInRoute(VehicleRoute route) {
        Capacity maxLoad = this.stateGetter.getRouteState(route, InternalStates.MAXLOAD, Capacity.class);
        if (maxLoad == null) {
            maxLoad = Capacity.Builder.newInstance().build();
        }
        return maxLoad;
    }

    @Override
    public double getCosts(JobInsertionContext insertionContext) {
        return this.getFixCostContribution(insertionContext.getRoute(), insertionContext.getJob(), insertionContext.getNewVehicle());
    }
}

