/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionDataUpdater;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.algorithm.recreate.VersionedInsertionData;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.DependencyType;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegretInsertionFast
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(RegretInsertionFast.class);
    private ScoringFunction scoringFunction;
    private JobInsertionCostsCalculator insertionCostsCalculator;
    private VehicleFleetManager fleetManager;
    private Set<String> initialVehicleIds;
    private boolean switchAllowed = true;
    private DependencyType[] dependencyTypes = null;

    public RegretInsertionFast(JobInsertionCostsCalculator jobInsertionCalculator, VehicleRoutingProblem vehicleRoutingProblem, VehicleFleetManager fleetManager) {
        super(vehicleRoutingProblem);
        this.scoringFunction = new DefaultScorer(vehicleRoutingProblem);
        this.insertionCostsCalculator = jobInsertionCalculator;
        this.fleetManager = fleetManager;
        this.vrp = vehicleRoutingProblem;
        this.initialVehicleIds = this.getInitialVehicleIds(vehicleRoutingProblem);
        logger.debug("initialise {}", (Object)this);
    }

    public void setScoringFunction(ScoringFunction scoringFunction) {
        this.scoringFunction = scoringFunction;
    }

    public void setSwitchAllowed(boolean switchAllowed) {
        this.switchAllowed = switchAllowed;
    }

    public void setDependencyTypes(DependencyType[] dependencyTypes) {
        this.dependencyTypes = dependencyTypes;
    }

    private Set<String> getInitialVehicleIds(VehicleRoutingProblem vehicleRoutingProblem) {
        HashSet<String> ids = new HashSet<String>();
        for (VehicleRoute r : vehicleRoutingProblem.getInitialVehicleRoutes()) {
            ids.add(r.getVehicle().getId());
        }
        return ids;
    }

    public String toString() {
        return "[name=regretInsertion][additionalScorer=" + this.scoringFunction + "]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        ArrayList<Job> jobs = new ArrayList<Job>(unassignedJobs);
        TreeSet[] priorityQueues = new TreeSet[this.vrp.getJobs().values().size() + 2];
        VehicleRoute lastModified = null;
        boolean firstRun = true;
        int updateRound = 0;
        HashMap<VehicleRoute, Integer> updates = new HashMap<VehicleRoute, Integer>();
        while (!jobs.isEmpty()) {
            ArrayList<Job> unassignedJobList = new ArrayList<Job>(jobs);
            ArrayList<Job> badJobList = new ArrayList<Job>();
            if (!firstRun && lastModified == null) {
                throw new IllegalStateException("last modified route is null. this should not be.");
            }
            if (firstRun) {
                this.updateInsertionData(priorityQueues, routes, unassignedJobList, updateRound, firstRun, lastModified, updates);
                firstRun = false;
            } else {
                this.updateInsertionData(priorityQueues, routes, unassignedJobList, updateRound, firstRun, lastModified, updates);
            }
            ++updateRound;
            ScoredJob bestScoredJob = InsertionDataUpdater.getBest(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, this.scoringFunction, priorityQueues, updates, unassignedJobList, badJobList);
            if (bestScoredJob != null) {
                if (bestScoredJob.isNewRoute()) {
                    routes.add(bestScoredJob.getRoute());
                }
                this.insertJob(bestScoredJob.getJob(), bestScoredJob.getInsertionData(), bestScoredJob.getRoute());
                jobs.remove(bestScoredJob.getJob());
                lastModified = bestScoredJob.getRoute();
            } else {
                lastModified = null;
            }
            for (Job bad : badJobList) {
                jobs.remove(bad);
                badJobs.add(bad);
            }
        }
        return badJobs;
    }

    private void updateInsertionData(TreeSet<VersionedInsertionData>[] priorityQueues, Collection<VehicleRoute> routes, List<Job> unassignedJobList, int updateRound, boolean firstRun, VehicleRoute lastModified, Map<VehicleRoute, Integer> updates) {
        for (Job unassignedJob : unassignedJobList) {
            if (priorityQueues[unassignedJob.getIndex()] == null) {
                priorityQueues[unassignedJob.getIndex()] = new TreeSet<VersionedInsertionData>(InsertionDataUpdater.getComparator());
            }
            if (firstRun) {
                InsertionDataUpdater.update(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes);
                for (VehicleRoute r : routes) {
                    updates.put(r, updateRound);
                }
                continue;
            }
            if (this.dependencyTypes == null || this.dependencyTypes[unassignedJob.getIndex()] == null) {
                InsertionDataUpdater.update(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, Arrays.asList(lastModified));
                updates.put(lastModified, updateRound);
                continue;
            }
            DependencyType dependencyType = this.dependencyTypes[unassignedJob.getIndex()];
            if (dependencyType.equals((Object)DependencyType.INTER_ROUTE) || dependencyType.equals((Object)DependencyType.INTRA_ROUTE)) {
                InsertionDataUpdater.update(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes);
                for (VehicleRoute r : routes) {
                    updates.put(r, updateRound);
                }
                continue;
            }
            InsertionDataUpdater.update(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, Arrays.asList(lastModified));
            updates.put(lastModified, updateRound);
        }
    }
}

