/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.Event;
import com.graphhopper.jsprit.core.algorithm.recreate.EventListener;
import com.graphhopper.jsprit.core.algorithm.recreate.SwitchVehicle;
import com.graphhopper.jsprit.core.problem.job.Break;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwitchVehicleListener
implements EventListener {
    private static final Logger logger = LoggerFactory.getLogger(SwitchVehicleListener.class);

    SwitchVehicleListener() {
    }

    @Override
    public void inform(Event event) {
        if (event instanceof SwitchVehicle) {
            SwitchVehicle switchVehicle = (SwitchVehicle)event;
            if (this.vehiclesDifferent((SwitchVehicle)event)) {
                boolean removed;
                logger.trace("switch vehicle ({} to {})", (Object)((SwitchVehicle)event).getRoute().getVehicle().getId(), (Object)((SwitchVehicle)event).getVehicle().getId());
                Break aBreak = ((SwitchVehicle)event).getRoute().getVehicle().getBreak();
                if (aBreak != null && (removed = ((SwitchVehicle)event).getRoute().getTourActivities().removeJob(aBreak))) {
                    logger.trace("remove {}", (Object)aBreak.getId());
                }
            }
            switchVehicle.getRoute().setVehicleAndDepartureTime(switchVehicle.getVehicle(), ((SwitchVehicle)event).getDepartureTime());
        }
    }

    private boolean vehiclesDifferent(SwitchVehicle event) {
        return !event.getRoute().getVehicle().getId().equals(event.getVehicle().getId());
    }
}

