/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VehicleTypeDependentJobInsertionCalculator
implements JobInsertionCostsCalculator {
    private Logger logger = LoggerFactory.getLogger(VehicleTypeDependentJobInsertionCalculator.class);
    private final VehicleFleetManager fleetManager;
    private final JobInsertionCostsCalculator insertionCalculator;
    private final VehicleRoutingProblem vrp;
    private Set<String> initialVehicleIds = new HashSet<String>();
    private boolean vehicleSwitchAllowed = false;

    public VehicleTypeDependentJobInsertionCalculator(VehicleRoutingProblem vrp, VehicleFleetManager fleetManager, JobInsertionCostsCalculator jobInsertionCalc) {
        this.fleetManager = fleetManager;
        this.insertionCalculator = jobInsertionCalc;
        this.vrp = vrp;
        this.getInitialVehicleIds();
        this.logger.debug("initialise " + this);
    }

    private void getInitialVehicleIds() {
        Collection<VehicleRoute> initialVehicleRoutes = this.vrp.getInitialVehicleRoutes();
        for (VehicleRoute initialRoute : initialVehicleRoutes) {
            this.initialVehicleIds.add(initialRoute.getVehicle().getId());
        }
    }

    public String toString() {
        return "[name=vehicleTypeDependentServiceInsertion]";
    }

    public boolean isVehicleSwitchAllowed() {
        return this.vehicleSwitchAllowed;
    }

    public void setVehicleSwitchAllowed(boolean vehicleSwitchAllowed) {
        this.logger.debug("set vehicleSwitchAllowed to " + vehicleSwitchAllowed);
        this.vehicleSwitchAllowed = vehicleSwitchAllowed;
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle vehicle, double newVehicleDepartureTime, Driver driver, double bestKnownCost) {
        if (vehicle != null) {
            return this.insertionCalculator.getInsertionData(currentRoute, jobToInsert, vehicle, newVehicleDepartureTime, driver, bestKnownCost);
        }
        Vehicle selectedVehicle = currentRoute.getVehicle();
        Driver selectedDriver = currentRoute.getDriver();
        InsertionData bestIData = InsertionData.createEmptyInsertionData();
        double bestKnownCost_ = bestKnownCost;
        ArrayList<Vehicle> relevantVehicles = new ArrayList<Vehicle>();
        if (!(selectedVehicle instanceof VehicleImpl.NoVehicle)) {
            relevantVehicles.add(selectedVehicle);
            if (this.vehicleSwitchAllowed && !this.isVehicleWithInitialRoute(selectedVehicle)) {
                relevantVehicles.addAll(this.fleetManager.getAvailableVehicles(selectedVehicle));
            }
        } else {
            relevantVehicles.addAll(this.fleetManager.getAvailableVehicles());
        }
        Iterator iterator = relevantVehicles.iterator();
        while (iterator.hasNext()) {
            Vehicle v;
            double depTime = (v = (Vehicle)iterator.next()) == selectedVehicle ? currentRoute.getDepartureTime() : v.getEarliestDeparture();
            InsertionData iData = this.insertionCalculator.getInsertionData(currentRoute, jobToInsert, v, depTime, selectedDriver, bestKnownCost_);
            if (iData instanceof InsertionData.NoInsertionFound || !(iData.getInsertionCost() < bestKnownCost_)) continue;
            bestIData = iData;
            bestKnownCost_ = iData.getInsertionCost();
        }
        return bestIData;
    }

    VehicleFleetManager getFleetManager() {
        return this.fleetManager;
    }

    private boolean isVehicleWithInitialRoute(Vehicle selectedVehicle) {
        return this.initialVehicleIds.contains(selectedVehicle.getId());
    }
}

