/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoodsImpl;
import com.graphhopper.jsprit.core.algorithm.ruin.ReferencedJob;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.util.StopWatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobNeighborhoodsOptimized
implements JobNeighborhoods {
    private static Logger logger = LoggerFactory.getLogger(JobNeighborhoodsImpl.class);
    private VehicleRoutingProblem vrp;
    private int[][] neighbors;
    private Job[] jobs;
    private JobDistance jobDistance;
    private int capacity;
    private double maxDistance = 0.0;

    public JobNeighborhoodsOptimized(VehicleRoutingProblem vrp, JobDistance jobDistance, int capacity) {
        this.vrp = vrp;
        this.jobDistance = jobDistance;
        this.capacity = capacity;
        this.neighbors = new int[vrp.getJobsInclusiveInitialJobsInRoutes().size() + 1][capacity];
        this.jobs = new Job[vrp.getJobsInclusiveInitialJobsInRoutes().size() + 1];
        logger.debug("initialize {}", (Object)this);
    }

    @Override
    public Iterator<Job> getNearestNeighborsIterator(int nNeighbors, Job neighborTo) {
        int[] neighbors = this.neighbors[neighborTo.getIndex() - 1];
        return new ArrayIterator(nNeighbors, neighbors, this.jobs);
    }

    @Override
    public void initialise() {
        logger.debug("calculates distances from EACH job to EACH job --> n^2={} calculations, but 'only' {} are cached.", (Object)Math.pow(this.vrp.getJobs().values().size(), 2.0), (Object)(this.vrp.getJobs().values().size() * this.capacity));
        if (this.capacity == 0) {
            return;
        }
        this.calculateDistancesFromJob2Job();
    }

    @Override
    public double getMaxDistance() {
        return this.maxDistance;
    }

    private void calculateDistancesFromJob2Job() {
        logger.debug("pre-process distances between locations ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Iterator<Job> iterator = this.vrp.getJobsInclusiveInitialJobsInRoutes().values().iterator();
        while (iterator.hasNext()) {
            Job job_i;
            this.jobs[job_i.getIndex()] = job_i = iterator.next();
            ArrayList<ReferencedJob> jobList = new ArrayList<ReferencedJob>(this.vrp.getJobsInclusiveInitialJobsInRoutes().values().size());
            for (Job job_j : this.vrp.getJobsInclusiveInitialJobsInRoutes().values()) {
                if (job_i == job_j) continue;
                double distance = this.jobDistance.getDistance(job_i, job_j);
                if (distance > this.maxDistance) {
                    this.maxDistance = distance;
                }
                ReferencedJob referencedJob = new ReferencedJob(job_j, distance);
                jobList.add(referencedJob);
            }
            Collections.sort(jobList, this.getComparator());
            int[] jobIndices = new int[this.capacity];
            for (int index = 0; index < this.capacity; ++index) {
                jobIndices[index] = ((ReferencedJob)jobList.get(index)).getJob().getIndex();
            }
            this.neighbors[job_i.getIndex() - 1] = jobIndices;
        }
        stopWatch.stop();
        logger.debug("pre-processing comp-time: {}", (Object)stopWatch);
    }

    private Comparator<ReferencedJob> getComparator() {
        return new Comparator<ReferencedJob>(){

            @Override
            public int compare(ReferencedJob o1, ReferencedJob o2) {
                if (o1.getDistance() < o2.getDistance()) {
                    return -1;
                }
                if (o1.getDistance() > o2.getDistance()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public String toString() {
        return "[name=neighborhoodWithCapRestriction][capacity=" + this.capacity + "]";
    }

    static class ArrayIterator
    implements Iterator<Job> {
        private final int noItems;
        private final int[] itemArray;
        private final Job[] jobs;
        private int index = 0;

        public ArrayIterator(int noItems, int[] itemArray, Job[] jobs) {
            this.noItems = noItems;
            this.itemArray = itemArray;
            this.jobs = jobs;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.noItems && this.index < this.itemArray.length;
        }

        @Override
        public Job next() {
            Job job = this.jobs[this.itemArray[this.index]];
            ++this.index;
            return job;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

