/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoodsImplWithCapRestriction;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinShareFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class RuinRadialMultipleCenters
extends AbstractRuinStrategy {
    private Logger logger = LoggerFactory.getLogger(RuinRadialMultipleCenters.class);
    private VehicleRoutingProblem vrp;
    private JobNeighborhoods jobNeighborhoods;
    private final int noJobsToMemorize;
    private int noCenters = 1;

    public RuinRadialMultipleCenters(VehicleRoutingProblem vrp, int neighborhoodSize, JobDistance jobDistance) {
        super(vrp);
        this.vrp = vrp;
        this.noJobsToMemorize = neighborhoodSize;
        this.ruinShareFactory = new RuinShareFactory(){

            @Override
            public int createNumberToBeRemoved() {
                return RuinRadialMultipleCenters.this.noJobsToMemorize;
            }
        };
        JobNeighborhoodsImplWithCapRestriction jobNeighborhoodsImpl = new JobNeighborhoodsImplWithCapRestriction(vrp, jobDistance, this.noJobsToMemorize);
        jobNeighborhoodsImpl.initialise();
        this.jobNeighborhoods = jobNeighborhoodsImpl;
        this.logger.debug("initialise {}", (Object)this);
    }

    public void setNumberOfRuinCenters(int noCenters) {
        this.noCenters = noCenters;
    }

    public String toString() {
        return "[name=radialRuin][noJobsToBeRemoved=" + this.noJobsToMemorize + "]";
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        if (vehicleRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Job> available = new HashSet<Job>(this.vrp.getJobs().values());
        ArrayList<Job> ruined = new ArrayList<Job>();
        for (int center = 0; center < this.noCenters; ++center) {
            int nOfJobs2BeRemoved = this.ruinShareFactory.createNumberToBeRemoved();
            if (nOfJobs2BeRemoved == 0) {
                return Collections.emptyList();
            }
            Job randomJob = this.pickRandomJob(available);
            if (randomJob == null) continue;
            ruined.addAll(this.ruinRoutes_(vehicleRoutes, randomJob, nOfJobs2BeRemoved, available));
        }
        return ruined;
    }

    private Collection<Job> ruinRoutes_(Collection<VehicleRoute> vehicleRoutes, Job targetJob, int nOfJobs2BeRemoved, Set<Job> available) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int nNeighbors = nOfJobs2BeRemoved - 1;
        this.removeJob(targetJob, vehicleRoutes);
        unassignedJobs.add(targetJob);
        Iterator<Job> neighborhoodIterator = this.jobNeighborhoods.getNearestNeighborsIterator(nNeighbors, targetJob);
        while (neighborhoodIterator.hasNext()) {
            Job job = neighborhoodIterator.next();
            if (available != null) {
                available.remove(job);
            }
            if (!this.removeJob(job, vehicleRoutes)) continue;
            unassignedJobs.add(job);
        }
        return unassignedJobs;
    }

    private Job pickRandomJob(Set<Job> available) {
        int randomIndex = this.random.nextInt(available.size());
        int i = 0;
        for (Job j : available) {
            if (i >= randomIndex) {
                return j;
            }
            ++i;
        }
        return null;
    }
}

