/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.StateId;
import java.util.Arrays;
import java.util.List;

class StateFactory {
    static final List<String> reservedIds = Arrays.asList("max_load", "load", "costs", "load_at_beginning", "load_at_end", "duration", "latest_operation_start_time", "earliest_operation_start_time", "future_max_load", "past_max_load", "skills");

    StateFactory() {
    }

    static StateId createId(String name) {
        if (reservedIds.contains(name)) {
            StateFactory.throwReservedIdException(name);
        }
        return new StateIdImpl(name, -1);
    }

    static StateId createId(String name, int index) {
        if (reservedIds.contains(name)) {
            StateFactory.throwReservedIdException(name);
        }
        if (index < 10) {
            StateFactory.throwReservedIdException(name);
        }
        return new StateIdImpl(name, index);
    }

    static boolean isReservedId(String stateId) {
        return reservedIds.contains(stateId);
    }

    static boolean isReservedId(StateId stateId) {
        return reservedIds.contains(stateId.toString());
    }

    static void throwReservedIdException(String name) {
        throw new IllegalStateException("state-id with name '" + name + "' cannot be created. it is already reserved internally.");
    }

    static class StateIdImpl
    implements StateId {
        private int index;
        private String name;

        @Override
        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateIdImpl other = (StateIdImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public StateIdImpl(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }
    }
}

