/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionEndsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListeners;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListeners;
import com.graphhopper.jsprit.core.algorithm.state.StateFactory;
import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.algorithm.state.UpdateLoads;
import com.graphhopper.jsprit.core.algorithm.state.UpdateMaxCapacityUtilisationAtActivitiesByLookingBackwardInRoute;
import com.graphhopper.jsprit.core.algorithm.state.UpdateMaxCapacityUtilisationAtActivitiesByLookingForwardInRoute;
import com.graphhopper.jsprit.core.algorithm.state.UpdateMaxCapacityUtilisationAtRoute;
import com.graphhopper.jsprit.core.algorithm.state.UpdateSkills;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.ReverseRouteActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.RouteActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.RouteVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StateManager
implements RouteAndActivityStateGetter,
IterationStartsListener,
RuinListener,
InsertionStartsListener,
JobInsertedListener,
InsertionEndsListener {
    private RouteActivityVisitor routeActivityVisitor = new RouteActivityVisitor();
    private ReverseRouteActivityVisitor revRouteActivityVisitor = new ReverseRouteActivityVisitor();
    private Collection<RouteVisitor> routeVisitors = new ArrayList<RouteVisitor>();
    private RuinListeners ruinListeners = new RuinListeners();
    private InsertionListeners insertionListeners = new InsertionListeners();
    private Collection<StateUpdater> updaters = new ArrayList<StateUpdater>();
    private boolean updateLoad = false;
    private boolean updateTWs = false;
    private final int initialNoStates = 21;
    private int stateIndexCounter = 21;
    private Map<String, StateId> createdStateIds = new HashMap<String, StateId>();
    private int nuActivities;
    private int nuVehicleTypeKeys;
    private Object[] problemStates;
    private Object[][] activityStates;
    private Object[][][] vehicleDependentActivityStates;
    private Map<VehicleRoute, Object[]> routeStateMap;
    private Map<VehicleRoute, Object[][]> vehicleDependentRouteStateMap;
    private Object[][] routeStatesArr;
    private Object[][][] vehicleDependentRouteStatesArr;
    private VehicleRoutingProblem vrp;
    private final boolean isIndexedBased;

    int getMaxIndexOfVehicleTypeIdentifiers() {
        return this.nuVehicleTypeKeys;
    }

    public StateId createStateId(String name) {
        if (this.createdStateIds.containsKey(name)) {
            return this.createdStateIds.get(name);
        }
        if (this.stateIndexCounter >= this.activityStates[0].length) {
            this.activityStates = new Object[this.nuActivities][this.stateIndexCounter + 1];
            this.vehicleDependentActivityStates = new Object[this.nuActivities][this.nuVehicleTypeKeys][this.stateIndexCounter + 1];
            this.routeStatesArr = new Object[this.vrp.getVehicles().size() + 2][this.stateIndexCounter + 1];
            this.vehicleDependentRouteStatesArr = new Object[this.vrp.getVehicles().size() + 2][this.nuVehicleTypeKeys][this.stateIndexCounter + 1];
            this.problemStates = new Object[this.stateIndexCounter + 1];
        }
        StateId id = StateFactory.createId(name, this.stateIndexCounter);
        this.incStateIndexCounter();
        this.createdStateIds.put(name, id);
        return id;
    }

    private void incStateIndexCounter() {
        ++this.stateIndexCounter;
    }

    public StateManager(VehicleRoutingProblem vehicleRoutingProblem) {
        int initialStateArrayLength = 30;
        this.vrp = vehicleRoutingProblem;
        this.nuActivities = Math.max(10, this.vrp.getNuActivities() + 1);
        this.nuVehicleTypeKeys = Math.max(3, this.getNuVehicleTypes(this.vrp) + 2);
        this.activityStates = new Object[this.nuActivities][initialStateArrayLength];
        this.vehicleDependentActivityStates = new Object[this.nuActivities][this.nuVehicleTypeKeys][initialStateArrayLength];
        this.isIndexedBased = false;
        this.routeStateMap = new HashMap<VehicleRoute, Object[]>();
        this.vehicleDependentRouteStateMap = new HashMap<VehicleRoute, Object[][]>();
        this.problemStates = new Object[initialStateArrayLength];
    }

    private int getNuVehicleTypes(VehicleRoutingProblem vrp) {
        int maxIndex = 0;
        for (Vehicle v : vrp.getVehicles()) {
            maxIndex = Math.max(maxIndex, v.getVehicleTypeIdentifier().getIndex());
        }
        return maxIndex;
    }

    public <T> void putProblemState(StateId stateId, Class<T> type, T state) {
        this.problemStates[stateId.getIndex()] = state;
    }

    public <T> T getProblemState(StateId stateId, Class<T> type) {
        return type.cast(this.problemStates[stateId.getIndex()]);
    }

    public void clear() {
        this.fill_twoDimArr(this.activityStates, null);
        this.fill_threeDimArr(this.vehicleDependentActivityStates, null);
        if (this.isIndexedBased) {
            this.fill_twoDimArr(this.routeStatesArr, null);
            this.fill_threeDimArr(this.vehicleDependentRouteStatesArr, null);
        } else {
            this.routeStateMap.clear();
            this.vehicleDependentRouteStateMap.clear();
        }
        Arrays.fill(this.problemStates, null);
    }

    private void fill_threeDimArr(Object[][][] states, Object o) {
        Object[][][] objectArray = states;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[][] twoDimArr;
            for (Object[] oneDimArr : twoDimArr = objectArray[i]) {
                Arrays.fill(oneDimArr, o);
            }
        }
    }

    private void fill_twoDimArr(Object[][] states, Object o) {
        for (Object[] rows : states) {
            Arrays.fill(rows, o);
        }
    }

    @Override
    public <T> T getActivityState(TourActivity act, StateId stateId, Class<T> type) {
        T state;
        if (act.getIndex() == 0) {
            throw new IllegalStateException("activity index is 0. this should not be.");
        }
        if (act.getIndex() < 0) {
            return null;
        }
        try {
            state = type.cast(this.activityStates[act.getIndex()][stateId.getIndex()]);
        }
        catch (ClassCastException e) {
            throw this.getClassCastException(e, stateId, type.toString(), this.activityStates[act.getIndex()][stateId.getIndex()].getClass().toString());
        }
        return state;
    }

    public boolean hasActivityState(TourActivity act, Vehicle vehicle, StateId stateId) {
        if (act.getIndex() == 0) {
            throw new IllegalStateException("activity index is 0. this should not be.");
        }
        return this.vehicleDependentActivityStates[act.getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()] != null;
    }

    @Override
    public <T> T getActivityState(TourActivity act, Vehicle vehicle, StateId stateId, Class<T> type) {
        T state;
        if (act.getIndex() == 0) {
            throw new IllegalStateException("activity index is 0. this should not be.");
        }
        if (act.getIndex() < 0) {
            return null;
        }
        try {
            state = type.cast(this.vehicleDependentActivityStates[act.getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()]);
        }
        catch (ClassCastException e) {
            Object state_class = this.vehicleDependentActivityStates[act.getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()];
            throw this.getClassCastException(e, stateId, type.toString(), state_class.getClass().toString());
        }
        return state;
    }

    private ClassCastException getClassCastException(ClassCastException e, StateId stateId, String requestedTypeClass, String memorizedTypeClass) {
        return new ClassCastException(e + "\n" + "state with stateId '" + stateId.toString() + "' is of " + memorizedTypeClass + ". cannot cast it to " + requestedTypeClass + ".");
    }

    @Override
    public <T> T getRouteState(VehicleRoute route, StateId stateId, Class<T> type) {
        if (route.isEmpty()) {
            return null;
        }
        T state = null;
        if (this.isIndexedBased) {
            try {
                state = type.cast(this.routeStatesArr[route.getVehicle().getIndex()][stateId.getIndex()]);
            }
            catch (ClassCastException e) {
                throw this.getClassCastException(e, stateId, type.toString(), this.routeStatesArr[route.getVehicle().getIndex()][stateId.getIndex()].getClass().toString());
            }
        }
        try {
            if (this.routeStateMap.containsKey(route)) {
                state = type.cast(this.routeStateMap.get(route)[stateId.getIndex()]);
            }
        }
        catch (ClassCastException e) {
            throw this.getClassCastException(e, stateId, type.toString(), this.routeStateMap.get(route)[stateId.getIndex()].getClass().toString());
        }
        return state;
    }

    public boolean hasRouteState(VehicleRoute route, Vehicle vehicle, StateId stateId) {
        if (!this.vehicleDependentRouteStateMap.containsKey(route)) {
            return false;
        }
        return this.vehicleDependentRouteStateMap.get(route)[vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()] != null;
    }

    @Override
    public <T> T getRouteState(VehicleRoute route, Vehicle vehicle, StateId stateId, Class<T> type) {
        if (route.isEmpty()) {
            return null;
        }
        T state = null;
        if (this.isIndexedBased) {
            try {
                state = type.cast(this.vehicleDependentRouteStatesArr[route.getVehicle().getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()]);
            }
            catch (ClassCastException e) {
                throw this.getClassCastException(e, stateId, type.toString(), this.vehicleDependentRouteStatesArr[route.getVehicle().getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()].getClass().toString());
            }
        }
        try {
            if (this.vehicleDependentRouteStateMap.containsKey(route)) {
                state = type.cast(this.vehicleDependentRouteStateMap.get(route)[vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()]);
            }
        }
        catch (ClassCastException e) {
            throw this.getClassCastException(e, stateId, type.toString(), this.vehicleDependentRouteStateMap.get(route)[vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()].getClass().toString());
        }
        return state;
    }

    public <T> void putActivityState(TourActivity act, StateId stateId, T state) {
        if (act.getIndex() == 0) {
            throw new IllegalStateException("activity index is 0. this should not be.");
        }
        if (stateId.getIndex() < 21) {
            throw new IllegalStateException("either you use a reserved stateId that is applied\ninternally or your stateId has been created without index, e.g. StateFactory.createId(stateName)\n does not assign indeces thus do not use it anymore, but use\n stateManager.createStateId(name)\n instead.\n");
        }
        this.putInternalTypedActivityState(act, stateId, state);
    }

    public <T> void putActivityState(TourActivity act, Vehicle vehicle, StateId stateId, T state) {
        if (act.getIndex() == 0) {
            throw new IllegalStateException("activity index is 0. this should not be.");
        }
        if (stateId.getIndex() < 21) {
            throw new IllegalStateException("either you use a reserved stateId that is applied\ninternally or your stateId has been created without index, e.g. StateFactory.createId(stateName)\n does not assign indeces thus do not use it anymore, but use\n stateManager.createStateId(name)\n instead.\n");
        }
        this.putInternalTypedActivityState(act, vehicle, stateId, state);
    }

    <T> void putInternalTypedActivityState(TourActivity act, StateId stateId, T state) {
        this.activityStates[act.getIndex()][stateId.getIndex()] = state;
    }

    <T> void putInternalTypedActivityState(TourActivity act, Vehicle vehicle, StateId stateId, T state) {
        this.vehicleDependentActivityStates[act.getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()] = state;
    }

    public <T> void putRouteState(VehicleRoute route, StateId stateId, T state) {
        if (stateId.getIndex() < 21) {
            StateFactory.throwReservedIdException(stateId.toString());
        }
        this.putTypedInternalRouteState(route, stateId, state);
    }

    public <T> void putRouteState(VehicleRoute route, Vehicle vehicle, StateId stateId, T state) {
        if (vehicle.getIndex() == 0) {
            throw new IllegalStateException("vehicle index is 0. this should not be.");
        }
        if (stateId.getIndex() < 21) {
            StateFactory.throwReservedIdException(stateId.toString());
        }
        this.putTypedInternalRouteState(route, vehicle, stateId, state);
    }

    <T> void putTypedInternalRouteState(VehicleRoute route, StateId stateId, T state) {
        if (route.isEmpty()) {
            return;
        }
        if (this.isIndexedBased) {
            this.routeStatesArr[route.getVehicle().getIndex()][stateId.getIndex()] = state;
        } else {
            if (!this.routeStateMap.containsKey(route)) {
                this.routeStateMap.put(route, new Object[this.stateIndexCounter]);
            }
            this.routeStateMap.get((Object)route)[stateId.getIndex()] = state;
        }
    }

    <T> void putTypedInternalRouteState(VehicleRoute route, Vehicle vehicle, StateId stateId, T state) {
        if (route.isEmpty()) {
            return;
        }
        if (this.isIndexedBased) {
            this.vehicleDependentRouteStatesArr[route.getVehicle().getIndex()][vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()] = state;
        } else {
            if (!this.vehicleDependentRouteStateMap.containsKey(route)) {
                this.vehicleDependentRouteStateMap.put(route, new Object[this.nuVehicleTypeKeys][this.stateIndexCounter]);
            }
            this.vehicleDependentRouteStateMap.get((Object)route)[vehicle.getVehicleTypeIdentifier().getIndex()][stateId.getIndex()] = state;
        }
    }

    public void addStateUpdater(StateUpdater updater) {
        if (updater instanceof ActivityVisitor) {
            this.addActivityVisitor((ActivityVisitor)((Object)updater));
        }
        if (updater instanceof ReverseActivityVisitor) {
            this.addActivityVisitor((ReverseActivityVisitor)((Object)updater));
        }
        if (updater instanceof RouteVisitor) {
            this.addRouteVisitor((RouteVisitor)((Object)updater));
        }
        if (updater instanceof InsertionListener) {
            this.addListener((InsertionListener)((Object)updater));
        }
        if (updater instanceof RuinListener) {
            this.addListener((RuinListener)((Object)updater));
        }
        this.updaters.add(updater);
    }

    public void addAllStateUpdater(Collection<StateUpdater> updaters) {
        for (StateUpdater u : updaters) {
            this.addStateUpdater(u);
        }
    }

    Collection<StateUpdater> getStateUpdaters() {
        return Collections.unmodifiableCollection(this.updaters);
    }

    void addActivityVisitor(ActivityVisitor activityVistor) {
        this.routeActivityVisitor.addActivityVisitor(activityVistor);
    }

    void addActivityVisitor(ReverseActivityVisitor activityVistor) {
        this.revRouteActivityVisitor.addActivityVisitor(activityVistor);
    }

    void addRouteVisitor(RouteVisitor routeVisitor) {
        this.routeVisitors.add(routeVisitor);
    }

    void addListener(RuinListener ruinListener) {
        this.ruinListeners.addListener(ruinListener);
    }

    void addListener(InsertionListener insertionListener) {
        this.insertionListeners.addListener(insertionListener);
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        this.insertionListeners.informJobInserted(job2insert, inRoute, additionalCosts, additionalTime);
        for (RouteVisitor v : this.routeVisitors) {
            v.visit(inRoute);
        }
        this.routeActivityVisitor.visit(inRoute);
        this.revRouteActivityVisitor.visit(inRoute);
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        this.insertionListeners.informInsertionStarts(vehicleRoutes, unassignedJobs);
        for (VehicleRoute route : vehicleRoutes) {
            for (RouteVisitor v : this.routeVisitors) {
                v.visit(route);
            }
            this.routeActivityVisitor.visit(route);
            this.revRouteActivityVisitor.visit(route);
        }
    }

    public void reCalculateStates(VehicleRoute route) {
        this.informInsertionStarts(Arrays.asList(route), Collections.emptyList());
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.clear();
    }

    @Override
    public void ruinStarts(Collection<VehicleRoute> routes) {
        this.ruinListeners.ruinStarts(routes);
    }

    @Override
    public void ruinEnds(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        this.ruinListeners.ruinEnds(routes, unassignedJobs);
    }

    @Override
    public void removed(Job job, VehicleRoute fromRoute) {
        this.ruinListeners.removed(job, fromRoute);
    }

    @Override
    public void informInsertionEnds(Collection<VehicleRoute> vehicleRoutes) {
        this.insertionListeners.informInsertionEndsListeners(vehicleRoutes);
    }

    public void updateLoadStates() {
        if (!this.updateLoad) {
            this.updateLoad = true;
            UpdateLoads updateLoads = new UpdateLoads(this);
            this.addActivityVisitor(updateLoads);
            this.addListener(updateLoads);
            this.addActivityVisitor(new UpdateMaxCapacityUtilisationAtActivitiesByLookingBackwardInRoute(this));
            this.addActivityVisitor(new UpdateMaxCapacityUtilisationAtActivitiesByLookingForwardInRoute(this));
            this.addActivityVisitor(new UpdateMaxCapacityUtilisationAtRoute(this));
        }
    }

    public void updateTimeWindowStates() {
        this.updateTWs = true;
    }

    public boolean timeWindowUpdateIsActivated() {
        return this.updateTWs;
    }

    public void updateSkillStates() {
        this.addActivityVisitor(new UpdateSkills(this));
    }
}

