/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

class UpdateMaxCapacityUtilisationAtRoute
implements ActivityVisitor,
StateUpdater {
    private StateManager stateManager;
    private Capacity currentLoad = Capacity.Builder.newInstance().build();
    private VehicleRoute route;
    private Capacity maxLoad;
    private Capacity defaultValue;

    public UpdateMaxCapacityUtilisationAtRoute(StateManager stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public void begin(VehicleRoute route) {
        this.currentLoad = this.stateManager.getRouteState(route, InternalStates.LOAD_AT_BEGINNING, Capacity.class);
        if (this.currentLoad == null) {
            this.currentLoad = this.defaultValue;
        }
        this.maxLoad = this.currentLoad;
        this.route = route;
    }

    @Override
    public void visit(TourActivity act) {
        this.currentLoad = Capacity.addup(this.currentLoad, act.getSize());
        this.maxLoad = Capacity.max(this.maxLoad, this.currentLoad);
    }

    @Override
    public void finish() {
        this.stateManager.putTypedInternalRouteState(this.route, InternalStates.MAXLOAD, this.maxLoad);
    }
}

