/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

class UpdatePracticalTimeWindows
implements ReverseActivityVisitor,
StateUpdater {
    private StateManager states;
    private VehicleRoute route;
    private VehicleRoutingTransportCosts transportCosts;
    private VehicleRoutingActivityCosts activityCosts;
    private double latestArrTimeAtPrevAct;
    private TourActivity prevAct;

    public UpdatePracticalTimeWindows(StateManager states, VehicleRoutingTransportCosts tpCosts, VehicleRoutingActivityCosts activityCosts) {
        this.states = states;
        this.transportCosts = tpCosts;
        this.activityCosts = activityCosts;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.route = route;
        this.latestArrTimeAtPrevAct = route.getEnd().getTheoreticalLatestOperationStartTime();
        this.prevAct = route.getEnd();
    }

    @Override
    public void visit(TourActivity activity) {
        double potentialLatestArrivalTimeAtCurrAct = this.latestArrTimeAtPrevAct - this.transportCosts.getBackwardTransportTime(activity.getLocation(), this.prevAct.getLocation(), this.latestArrTimeAtPrevAct, this.route.getDriver(), this.route.getVehicle()) - this.activityCosts.getActivityDuration(activity, this.latestArrTimeAtPrevAct, this.route.getDriver(), this.route.getVehicle());
        double latestArrivalTime = Math.min(activity.getTheoreticalLatestOperationStartTime(), potentialLatestArrivalTimeAtCurrAct);
        this.states.putInternalTypedActivityState(activity, InternalStates.LATEST_OPERATION_START_TIME, latestArrivalTime);
        this.latestArrTimeAtPrevAct = latestArrivalTime;
        this.prevAct = activity;
    }

    @Override
    public void finish() {
    }
}

